/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Scanner;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.fixed.FixedWidthReadOptions;
import tech.tablesaw.io.fixed.FixedWidthReader;
import tech.tablesaw.io.html.HtmlReadOptions;
import tech.tablesaw.io.html.HtmlTableReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;
import tech.tablesaw.io.json.JsonReadOptions;
import tech.tablesaw.io.json.JsonReader;
import tech.tablesaw.io.xlsx.XlsxReadOptions;
import tech.tablesaw.io.xlsx.XlsxReader;

public class DataFrameReader {
    private final ReaderRegistry registry;

    public DataFrameReader(ReaderRegistry registry) {
        this.registry = registry;
    }

    public Table url(String url) throws IOException {
        return this.url(new URL(url));
    }

    public Table url(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String mimeType = connection.getContentType();
        DataReader<?> reader = this.registry.getReaderForMimeType(mimeType);
        return reader.read(new Source(connection.getInputStream()));
    }

    public Table string(String s, String fileExtension) throws IOException {
        DataReader<?> reader = this.registry.getReaderForExtension(fileExtension);
        return reader.read(Source.fromString(s));
    }

    public Table file(String file) throws IOException {
        return this.file(new File(file));
    }

    public Table file(File file) throws IOException {
        String extension = Files.getFileExtension((String)file.getCanonicalPath());
        DataReader<?> reader = this.registry.getReaderForExtension(extension);
        return reader.read(new Source(file));
    }

    public Table usingOptions(ReadOptions options) throws IOException {
        DataReader<?> reader = this.registry.getReaderForOptions(options);
        return reader.read(options.source());
    }

    public Table usingOptions(ReadOptions.Builder builder) throws IOException {
        return this.usingOptions(builder.build());
    }

    public Table csv(String file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(CsvReadOptions.builder(new StringReader(contents)).tableName(tableName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream) throws IOException {
        return this.csv(CsvReadOptions.builder(stream));
    }

    public Table csv(Reader reader) throws IOException {
        return this.csv(CsvReadOptions.builder(reader));
    }

    public Table csv(CsvReadOptions.Builder options) throws IOException {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) throws IOException {
        return new CsvReader().read(options);
    }

    public Table fixedWidth(String file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(File file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(InputStream stream) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(stream));
    }

    public Table fixedWidth(Reader reader) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(reader));
    }

    public Table fixedWidth(FixedWidthReadOptions.Builder options) throws IOException {
        return this.fixedWidth(options.build());
    }

    public Table fixedWidth(FixedWidthReadOptions options) throws IOException {
        return new FixedWidthReader().read(options);
    }

    public Table db(ResultSet resultSet) throws SQLException {
        return SqlResultSetReader.read(resultSet);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        Table table = SqlResultSetReader.read(resultSet);
        table.setName(tableName);
        return table;
    }

    public Table json(String url) throws MalformedURLException, IOException {
        return this.json(new StringReader(this.loadUrl(url)), url);
    }

    public Table json(Reader contents, String tableName) throws IOException {
        return new JsonReader().read(JsonReadOptions.builder((Reader)contents, (String)tableName).build());
    }

    public Table html(String url) throws IOException {
        return this.html(HtmlReadOptions.builder((Reader)new StringReader(this.loadUrl(url)), (String)url).build());
    }

    public Table html(HtmlReadOptions options) throws IOException {
        return new HtmlTableReader().read(options);
    }

    public List<Table> xlsx(XlsxReadOptions options) throws IOException {
        return new XlsxReader().readMultiple(options);
    }

    public List<Table> xlsx(XlsxReadOptions.Builder options) throws IOException {
        return this.xlsx(options.build());
    }

    private String loadUrl(String url) throws IOException {
        try (Scanner scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

