/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.io.CharStreams;
import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.util.Pair;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.FileReader;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader
extends FileReader {
    public CsvReader() {
    }

    public CsvReader(List<ColumnType> typeDetectionList) {
        super(typeDetectionList);
    }

    private Pair<Reader, ColumnType[]> getReaderAndColumnTypes(CsvReadOptions options) throws IOException {
        ColumnType[] types = options.columnTypes();
        byte[] bytesCache = null;
        if (types == null) {
            Reader reader = TableBuildingUtils.createReader(options, bytesCache);
            if (options.file() == null) {
                bytesCache = CharStreams.toString((Readable)reader).getBytes();
                reader = TableBuildingUtils.createReader(options, bytesCache);
            }
            types = this.detectColumnTypes(reader, options);
        }
        return Pair.create((Object)TableBuildingUtils.createReader(options, bytesCache), (Object)types);
    }

    public Table read(CsvReadOptions options) throws IOException {
        return this.read(options, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table read(CsvReadOptions options, boolean headerOnly) throws IOException {
        Pair<Reader, ColumnType[]> pair = this.getReaderAndColumnTypes(options);
        Reader reader = (Reader)pair.getKey();
        ColumnType[] types = (ColumnType[])pair.getValue();
        CsvParser parser = this.csvParser(options);
        try {
            Table table = this.parseRows(options, headerOnly, reader, types, (AbstractParser<?>)parser);
            return table;
        }
        finally {
            if (options.reader() == null) {
                parser.stopParsing();
                reader.close();
            }
        }
    }

    public String printColumnTypes(CsvReadOptions options) throws IOException {
        Table structure = this.read(options, true).structure();
        return this.getTypeString(structure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColumnType[] detectColumnTypes(Reader reader, CsvReadOptions options) {
        boolean header = options.header();
        int linesToSkip = header ? 1 : 0;
        CsvParser parser = this.csvParser(options);
        try {
            ColumnType[] columnTypeArray = this.getTypes(reader, options, linesToSkip, (AbstractParser<?>)parser);
            return columnTypeArray;
        }
        finally {
            parser.stopParsing();
        }
    }

    private CsvParser csvParser(CsvReadOptions options) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setFormat((Format)this.csvFormat(options));
        if (options.maxNumberOfColumns() != null) {
            settings.setMaxColumns(options.maxNumberOfColumns().intValue());
        }
        return new CsvParser(settings);
    }

    private CsvFormat csvFormat(CsvReadOptions options) {
        CsvFormat format = new CsvFormat();
        if (options.separator() != null) {
            format.setDelimiter(options.separator().charValue());
        }
        if (options.lineEnding() != null) {
            format.setLineSeparator(options.lineEnding());
        }
        if (options.commentPrefix() != null) {
            format.setComment(options.commentPrefix().charValue());
        }
        return format;
    }
}

