/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ReadOptions;

public class CsvReadOptions
extends ReadOptions {
    private final ColumnType[] columnTypes;
    private final Character separator;
    private final String lineEnding;
    private final Integer maxNumberOfColumns;
    private final Character commentPrefix;

    private CsvReadOptions(Builder builder) {
        super(builder);
        this.columnTypes = builder.columnTypes;
        this.separator = builder.separator;
        this.lineEnding = builder.lineEnding;
        this.maxNumberOfColumns = builder.maxNumberOfColumns;
        this.commentPrefix = builder.commentPrefix;
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return new Builder(stream).tableName(tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder(reader);
        return builder.tableName(tableName);
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public Reader reader() {
        return this.reader;
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public Character separator() {
        return this.separator;
    }

    public String lineEnding() {
        return this.lineEnding;
    }

    @Override
    public boolean sample() {
        return this.sample;
    }

    @Override
    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    @Override
    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    @Override
    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public Integer maxNumberOfColumns() {
        return this.maxNumberOfColumns;
    }

    public Character commentPrefix() {
        return this.commentPrefix;
    }

    public static class Builder
    extends ReadOptions.Builder {
        private Character separator = Character.valueOf(',');
        private String lineEnding;
        private ColumnType[] columnTypes;
        private Integer maxNumberOfColumns = 10000;
        private Character commentPrefix;

        public Builder(File file) {
            super(file);
        }

        public Builder(Reader reader) {
            super(reader);
        }

        public Builder(InputStream stream) {
            super(stream);
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        @Override
        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        @Override
        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        @Override
        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        @Override
        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder separator(char separator) {
            this.separator = Character.valueOf(separator);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        @Override
        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        @Override
        public Builder minimizeColumnSizes(boolean minimize) {
            this.minimizeColumnSizes = minimize;
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public Builder maxNumberOfColumns(Integer maxNumberOfColumns) {
            this.maxNumberOfColumns = maxNumberOfColumns;
            return this;
        }

        public Builder commentPrefix(char commentPrefix) {
            this.commentPrefix = Character.valueOf(commentPrefix);
            return this;
        }

        @Override
        public CsvReadOptions build() {
            return new CsvReadOptions(this);
        }
    }
}

