/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.CrossTab;
import tech.tablesaw.aggregate.PivotTable;
import tech.tablesaw.aggregate.Summarizer;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.DataFrameReader;
import tech.tablesaw.io.DataFrameWriter;
import tech.tablesaw.io.html.HtmlTableWriter;
import tech.tablesaw.joining.DataFrameJoiner;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.sorting.SortUtils;
import tech.tablesaw.sorting.comparators.IntComparatorChain;
import tech.tablesaw.table.Relation;
import tech.tablesaw.table.Rows;
import tech.tablesaw.table.StandardTableSliceGroup;
import tech.tablesaw.table.TableSliceGroup;

public class Table
extends Relation
implements Iterable<Row> {
    private final List<Column<?>> columnList = new ArrayList();
    private String name;

    private Table(String name) {
        this.name = name;
    }

    protected Table(String name, Column<?> ... columns) {
        this(name);
        for (Column<?> column : columns) {
            this.addColumns(new Column[]{column});
        }
    }

    public static Table create(String tableName) {
        return new Table(tableName);
    }

    public static Table create(String tableName, Column<?> ... columns) {
        return new Table(tableName, columns);
    }

    private static Sort first(String columnName, Sort.Order order) {
        return Sort.on(columnName, order);
    }

    private static Sort getSort(String ... columnNames) {
        Sort key = null;
        for (String s : columnNames) {
            if (key == null) {
                key = Table.first(s, Sort.Order.DESCEND);
                continue;
            }
            key.next(s, Sort.Order.DESCEND);
        }
        return key;
    }

    public static DataFrameReader read() {
        return new DataFrameReader();
    }

    public DataFrameWriter write() {
        return new DataFrameWriter(this);
    }

    @Override
    public Table addColumns(Column<?> ... cols) {
        for (Column<?> c : cols) {
            this.validateColumn(c);
            this.columnList.add(c);
        }
        return this;
    }

    private void validateColumn(Column<?> newColumn) {
        Preconditions.checkNotNull(newColumn, (Object)("Attempted to add a null to the columns in table " + this.name));
        ArrayList<String> stringList = new ArrayList<String>();
        for (String name : this.columnNames()) {
            stringList.add(name.toLowerCase());
        }
        if (stringList.contains(newColumn.name().toLowerCase())) {
            String message = String.format("Cannot add column with duplicate name %s to table %s", newColumn, this.name);
            throw new IllegalArgumentException(message);
        }
        this.checkColumnSize(newColumn);
    }

    private void checkColumnSize(Column<?> newColumn) {
        if (this.columnCount() != 0) {
            Preconditions.checkArgument((newColumn.size() == this.rowCount() ? 1 : 0) != 0, (Object)("Column " + newColumn.name() + " does not have the same number of rows as the other columns in the table."));
        }
    }

    public Table insertColumn(int index, Column<?> column) {
        this.validateColumn(column);
        this.columnList.add(index, column);
        return this;
    }

    public Table replaceColumn(int colIndex, Column<?> newColumn) {
        this.removeColumns(new Column[]{this.column(colIndex)});
        return this.insertColumn(colIndex, newColumn);
    }

    public Table replaceColumn(String columnName, Column<?> newColumn) {
        int colIndex = this.columnIndex(columnName);
        return this.replaceColumn(colIndex, newColumn);
    }

    @Override
    public Table setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Column<?> column(int columnIndex) {
        return this.columnList.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.columnList.size();
    }

    @Override
    public int rowCount() {
        int result = 0;
        if (!this.columnList.isEmpty()) {
            result = this.columnList.get(0).size();
        }
        return result;
    }

    @Override
    public List<Column<?>> columns() {
        return this.columnList;
    }

    public Column<?>[] columnArray() {
        return this.columnList.toArray(new Column[this.columnCount()]);
    }

    @Override
    public List<CategoricalColumn<?>> categoricalColumns(String ... columnNames) {
        ArrayList columns = new ArrayList();
        for (String columnName : columnNames) {
            columns.add(this.categoricalColumn(columnName));
        }
        return columns;
    }

    @Override
    public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).name().equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name));
        }
        return columnIndex;
    }

    @Override
    public int columnIndex(Column<?> column) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).equals(column)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", column.name(), this.name));
        }
        return columnIndex;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<String> columnNames() {
        return this.columnList.stream().map(Column::name).collect(Collectors.toList());
    }

    public Table copy() {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy(this.rowCount())});
        }
        int[] rows = new int[this.rowCount()];
        for (int i = 0; i < this.rowCount(); ++i) {
            rows[i] = i;
        }
        Rows.copyRowsToTable(rows, this, copy);
        return copy;
    }

    public Table emptyCopy() {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy()});
        }
        return copy;
    }

    public Table emptyCopy(int rowSize) {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy(rowSize)});
        }
        return copy;
    }

    public Table[] sampleSplit(double table1Proportion) {
        Table[] tables = new Table[2];
        int table1Count = (int)Math.round((double)this.rowCount() * table1Proportion);
        BitmapBackedSelection table2Selection = new BitmapBackedSelection();
        int i = 0;
        while (i < this.rowCount()) {
            table2Selection.add(i++);
        }
        BitmapBackedSelection table1Selection = new BitmapBackedSelection();
        Selection table1Records = Selection.selectNRowsAtRandom(table1Count, this.rowCount());
        IntIterator intIterator = table1Records.iterator();
        while (intIterator.hasNext()) {
            int table1Record = (Integer)intIterator.next();
            table1Selection.add(table1Record);
        }
        table2Selection.andNot(table1Selection);
        tables[0] = this.where(table1Selection);
        tables[1] = this.where(table2Selection);
        return tables;
    }

    public Table sampleX(double proportion) {
        Preconditions.checkArgument((proportion <= 1.0 && proportion >= 0.0 ? 1 : 0) != 0, (Object)"The sample proportion must be between 0 and 1");
        int tableSize = (int)Math.round((double)this.rowCount() * proportion);
        return this.where(Selection.selectNRowsAtRandom(tableSize, this.rowCount()));
    }

    public Table sampleN(int nRows) {
        Preconditions.checkArgument((nRows > 0 && nRows < this.rowCount() ? 1 : 0) != 0, (Object)"The number of rows sampled must be greater than 0 and less than the number of rows in the table.");
        return this.where(Selection.selectNRowsAtRandom(nRows, this.rowCount()));
    }

    @Override
    public void clear() {
        this.columnList.forEach(Column::clear);
    }

    @Override
    public Table first(int nRows) {
        int newRowCount = Math.min(nRows, this.rowCount());
        return this.inRange(0, newRowCount);
    }

    public Table last(int nRows) {
        int newRowCount = Math.min(nRows, this.rowCount());
        return this.inRange(this.rowCount() - newRowCount, this.rowCount());
    }

    public Table sortOn(int ... columnIndexes) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i : columnIndexes) {
            if (i >= 0) {
                names.add(this.columnList.get(i).name());
                continue;
            }
            names.add("-" + this.columnList.get(-i).name());
        }
        return this.sortOn(names.toArray(new String[names.size()]));
    }

    public Table sortOn(String ... columnNames) {
        Sort key = null;
        List names = this.columnNames().stream().map(String::toUpperCase).collect(Collectors.toList());
        for (String columnName : columnNames) {
            Sort.Order order = Sort.Order.ASCEND;
            if (!names.contains(columnName.toUpperCase())) {
                String prefix = columnName.substring(0, 1);
                columnName = columnName.substring(1, columnName.length());
                order = this.getOrder(prefix);
            }
            if (key == null) {
                key = Table.first(columnName, order);
                continue;
            }
            key.next(columnName, order);
        }
        return this.sortOn(key);
    }

    private Sort.Order getOrder(String prefix) {
        Sort.Order order;
        switch (prefix) {
            case "+": {
                order = Sort.Order.ASCEND;
                break;
            }
            case "-": {
                order = Sort.Order.DESCEND;
                break;
            }
            default: {
                throw new IllegalStateException("Column prefix: " + prefix + " is unknown.");
            }
        }
        return order;
    }

    public Table sortAscendingOn(String ... columnNames) {
        return this.sortOn(columnNames);
    }

    public Table sortDescendingOn(String ... columnNames) {
        Sort key = Table.getSort(columnNames);
        return this.sortOn(key);
    }

    public Table sortOn(Sort key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        if (key.size() == 1) {
            IntComparator comparator = SortUtils.getComparator(this, key);
            return this.sortOn(comparator);
        }
        IntComparatorChain chain = SortUtils.getChain(this, key);
        return this.sortOn(chain);
    }

    private Table sortOn(IntComparator rowComparator) {
        Table newTable = this.emptyCopy(this.rowCount());
        int[] newRows = this.rows();
        IntArrays.parallelQuickSort((int[])newRows, (IntComparator)rowComparator);
        Rows.copyRowsToTable(newRows, this, newTable);
        return newTable;
    }

    public Table sortOn(Comparator<Row> rowComparator) {
        Row row1 = new Row(this);
        Row row2 = new Row(this);
        return this.sortOn((k1, k2) -> {
            row1.at(k1);
            row2.at(k2);
            return rowComparator.compare(row1, row2);
        });
    }

    private int[] rows() {
        int[] rowIndexes = new int[this.rowCount()];
        for (int i = 0; i < this.rowCount(); ++i) {
            rowIndexes[i] = i;
        }
        return rowIndexes;
    }

    public void addRow(int rowIndex, Table sourceTable) {
        for (int i = 0; i < this.columnCount(); ++i) {
            this.column(i).appendObj(sourceTable.column(i).get(rowIndex));
        }
    }

    public void addRow(Row row) {
        for (int i = 0; i < row.columnCount(); ++i) {
            this.column(i).appendObj(row.getObject(i));
        }
    }

    public Table rows(int ... rowNumbers) {
        Preconditions.checkArgument((Ints.max((int[])rowNumbers) <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.with(rowNumbers));
    }

    public Table dropRows(int ... rowNumbers) {
        Preconditions.checkArgument((Ints.max((int[])rowNumbers) <= this.rowCount() ? 1 : 0) != 0);
        Selection selection = Selection.withRange(0, this.rowCount()).andNot(Selection.with(rowNumbers));
        return this.where(selection);
    }

    public Table inRange(int rowStart, int rowEnd) {
        Preconditions.checkArgument((rowEnd <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.withRange(rowStart, rowEnd));
    }

    public Table dropRange(int rowStart, int rowEnd) {
        Preconditions.checkArgument((rowEnd <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.withoutRange(0, this.rowCount(), rowStart, rowEnd));
    }

    public Table where(Selection selection) {
        Table newTable = this.emptyCopy(selection.size());
        Rows.copyRowsToTable(selection, this, newTable);
        return newTable;
    }

    public Table dropWhere(Selection selection) {
        BitmapBackedSelection opposite = new BitmapBackedSelection();
        opposite.addRange(0, this.rowCount());
        opposite.andNot(selection);
        Table newTable = this.emptyCopy(opposite.size());
        Rows.copyRowsToTable(opposite, this, newTable);
        return newTable;
    }

    public Table pivot(CategoricalColumn<?> column1, CategoricalColumn<?> column2, NumberColumn<?> column3, AggregateFunction<?, ?> aggregateFunction) {
        return PivotTable.pivot(this, column1, column2, column3, aggregateFunction);
    }

    public Table pivot(String column1Name, String column2Name, String column3Name, AggregateFunction<?, ?> aggregateFunction) {
        return this.pivot(this.categoricalColumn(column1Name), this.categoricalColumn(column2Name), this.numberColumn(column3Name), aggregateFunction);
    }

    public TableSliceGroup splitOn(String ... columns) {
        return this.splitOn(this.categoricalColumns(columns).toArray(new CategoricalColumn[columns.length]));
    }

    public TableSliceGroup splitOn(CategoricalColumn<?> ... columns) {
        return StandardTableSliceGroup.create(this, columns);
    }

    public String printHtml() {
        return HtmlTableWriter.write((Table)this);
    }

    @Override
    public Table structure() {
        Table t = new Table("Structure of " + this.name());
        IntColumn index = IntColumn.indexColumn("Index", this.columnCount(), 0);
        StringColumn columnName = StringColumn.create("Column Name", this.columnCount());
        StringColumn columnType = StringColumn.create("Column Type", this.columnCount());
        t.addColumns(new Column[]{index});
        t.addColumns(new Column[]{columnName});
        t.addColumns(new Column[]{columnType});
        for (int i = 0; i < this.columnCount(); ++i) {
            Column<?> column = this.columnList.get(i);
            columnType.set(i, column.type().name());
            columnName.set(i, this.columnNames().get(i));
        }
        return t;
    }

    public Table dropDuplicateRows() {
        Table sorted = this.sortOn(this.columnNames().toArray(new String[this.columns().size()]));
        Table temp = this.emptyCopy();
        for (int row = 0; row < this.rowCount(); ++row) {
            if (!temp.isEmpty() && Rows.compareRows(row, sorted, temp)) continue;
            Rows.appendRowToTable(row, sorted, temp);
        }
        return temp;
    }

    public Table dropRowsWithMissingValues() {
        BitmapBackedSelection missing = new BitmapBackedSelection();
        block0: for (int row = 0; row < this.rowCount(); ++row) {
            for (int col = 0; col < this.columnCount(); ++col) {
                Column<?> c = this.column(col);
                if (!c.isMissing(row)) continue;
                missing.add(row);
                continue block0;
            }
        }
        Selection notMissing = Selection.withRange(0, this.rowCount());
        notMissing.andNot(missing);
        Table temp = this.emptyCopy(notMissing.size());
        Rows.copyRowsToTable(notMissing, this, temp);
        return temp;
    }

    public Table select(Column<?> ... columns) {
        return new Table(this.name, columns);
    }

    public Table select(String ... columnNames) {
        return Table.create(this.name, this.columns(columnNames).toArray(new Column[0]));
    }

    @Override
    public Table removeColumns(Column<?> ... columns) {
        this.columnList.removeAll(Arrays.asList(columns));
        return this;
    }

    public Table removeColumnsWithMissingValues() {
        this.removeColumns((Column[])this.columnList.stream().filter(x -> x.countMissing() > 0).toArray(Column[]::new));
        return this;
    }

    public Table retainColumns(Column<?> ... columns) {
        List<Column<?>> retained = Arrays.asList(columns);
        this.columnList.clear();
        this.columnList.addAll(retained);
        return this;
    }

    public Table retainColumns(String ... columnNames) {
        List<Column<?>> retained = this.columns(columnNames);
        this.columnList.clear();
        this.columnList.addAll(retained);
        return this;
    }

    public Table append(Table tableToAppend) {
        for (Column<?> column : this.columnList) {
            Column<?> columnToAppend = tableToAppend.column(column.name());
            column.append(columnToAppend);
        }
        return this;
    }

    public Table concat(Table tableToConcatenate) {
        Preconditions.checkArgument((tableToConcatenate.rowCount() == this.rowCount() ? 1 : 0) != 0, (Object)"Both tables must have the same number of rows to concatenate them.");
        for (Column<?> column : tableToConcatenate.columns()) {
            this.addColumns(new Column[]{column});
        }
        return this;
    }

    public Summarizer summarize(String columName, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(columName), functions);
    }

    public Summarizer summarize(List<String> columnNames, AggregateFunction<?, ?> ... functions) {
        return new Summarizer(this, columnNames, functions);
    }

    public Summarizer summarize(String numericColumn1Name, String numericColumn2Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(numericColumn1Name), this.column(numericColumn2Name), functions);
    }

    public Summarizer summarize(String col1Name, String col2Name, String col3Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(col1Name), this.column(col2Name), this.column(col3Name), functions);
    }

    public Summarizer summarize(String col1Name, String col2Name, String col3Name, String col4Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(col1Name), this.column(col2Name), this.column(col3Name), this.column(col4Name), functions);
    }

    public Summarizer summarize(Column<?> numberColumn, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, numberColumn, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, Column<?> column3, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, column3, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, Column<?> column3, Column<?> column4, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, column3, column4, function);
    }

    public Table xTabCounts(String column1Name, String column2Name) {
        return CrossTab.counts(this, this.categoricalColumn(column1Name), this.categoricalColumn(column2Name));
    }

    public Table xTabRowPercents(String column1Name, String column2Name) {
        return CrossTab.rowPercents(this, column1Name, column2Name);
    }

    public Table xTabColumnPercents(String column1Name, String column2Name) {
        return CrossTab.columnPercents(this, column1Name, column2Name);
    }

    public Table xTabTablePercents(String column1Name, String column2Name) {
        return CrossTab.tablePercents(this, column1Name, column2Name);
    }

    public Table xTabPercents(String column1Name) {
        return CrossTab.percents(this, column1Name);
    }

    public Table xTabCounts(String column1Name) {
        return CrossTab.counts(this, column1Name);
    }

    public Table countBy(CategoricalColumn<?> groupingColumn) {
        return groupingColumn.countByCategory();
    }

    public DataFrameJoiner join(String ... columnNames) {
        return new DataFrameJoiner(this, columnNames);
    }

    public Table missingValueCounts() {
        return this.summarize(this.columnNames(), AggregateFunctions.countMissing).apply();
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private final Row row;
            {
                this.row = new Row(Table.this);
            }

            @Override
            public Row next() {
                return this.row.next();
            }

            @Override
            public boolean hasNext() {
                return this.row.hasNext();
            }
        };
    }

    public void doWithRows(Consumer<Row> doable) {
        Row row = new Row(this);
        while (row.hasNext()) {
            doable.accept(row.next());
        }
    }

    public boolean detect(Predicate<Row> predicate) {
        Row row = new Row(this);
        while (row.hasNext()) {
            if (!predicate.test(row.next())) continue;
            return true;
        }
        return false;
    }

    public void stepWithRows(Consumer<Row[]> rowConsumer, int n) {
        if (this.isEmpty()) {
            return;
        }
        Row[] rows = new Row[n];
        for (int i = 0; i < n; ++i) {
            rows[i] = new Row(this);
        }
        int max = this.rowCount() / n;
        for (int i = 0; i < max; ++i) {
            for (int r = 1; r <= n; ++r) {
                int row = i * n + r - 1;
                rows[r - 1].at(row);
            }
            rowConsumer.accept(rows);
        }
    }

    public void doWithRows(Pairs pairs) {
        if (this.isEmpty()) {
            return;
        }
        Row row1 = new Row(this);
        Row row2 = new Row(this);
        int max = this.rowCount();
        for (int i = 1; i < max; ++i) {
            row1.at(i - 1);
            row2.at(i);
            pairs.doWithPair(row1, row2);
        }
    }

    public void doWithRowPairs(Consumer<RowPair> pairConsumer) {
        if (this.isEmpty()) {
            return;
        }
        Row row1 = new Row(this);
        Row row2 = new Row(this);
        RowPair pair = new RowPair(row1, row2);
        int max = this.rowCount();
        for (int i = 1; i < max; ++i) {
            row1.at(i - 1);
            row2.at(i);
            pairConsumer.accept(pair);
        }
    }

    public void rollWithRows(Consumer<Row[]> rowConsumer, int n) {
        if (this.isEmpty()) {
            return;
        }
        Row[] rows = new Row[n];
        for (int i = 0; i < n; ++i) {
            rows[i] = new Row(this);
        }
        int max = this.rowCount() - (n - 2);
        for (int i = 1; i < max; ++i) {
            for (int r = 0; r < n; ++r) {
                rows[r].at(i + r - 1);
            }
            rowConsumer.accept(rows);
        }
    }

    static interface Pairs {
        public void doWithPair(Row var1, Row var2);

        default public Object getResult() {
            throw new UnsupportedOperationException("This Pairs function returns no results");
        }
    }

    public static class RowPair {
        private final Row first;
        private final Row second;

        public RowPair(Row first, Row second) {
            this.first = first;
            this.second = second;
        }

        public Row getFirst() {
            return this.first;
        }

        public Row getSecond() {
            return this.second;
        }
    }
}

