/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.json.JsonWriteOptions;

@Immutable
public final class JsonWriter {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final JsonWriteOptions options;

    public JsonWriter(JsonWriteOptions options) {
        this.options = options;
    }

    public String write(Table table) throws JsonProcessingException {
        ArrayNode output = mapper.createArrayNode();
        if (this.options.asObjects()) {
            for (int r = 0; r < table.rowCount(); ++r) {
                ObjectNode row = mapper.createObjectNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.set(table.column(c).name(), (JsonNode)mapper.convertValue(table.get(r, c), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
        } else {
            if (this.options.header()) {
                ArrayNode row = mapper.createArrayNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.add((JsonNode)mapper.convertValue((Object)table.column(c).name(), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
            for (int r = 0; r < table.rowCount(); ++r) {
                ArrayNode row = mapper.createArrayNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.add((JsonNode)mapper.convertValue(table.get(r, c), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
        }
        return mapper.writeValueAsString((Object)output);
    }
}

