/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.fixed;

import com.univocity.parsers.common.Format;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthWriterSettings;
import java.io.Writer;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.fixed.FixedWidthWriteOptions;

@Immutable
public final class FixedWidthWriter {
    private final Table table;
    private final boolean header;
    private final Writer writer;
    private final FixedWidthWriterSettings settings;
    private final FixedWidthFormat format;

    public FixedWidthWriter(Table table, FixedWidthWriteOptions options) {
        this.table = table;
        this.header = options.header();
        this.writer = options.writer();
        this.settings = this.fixedWidthWriterSettings(options);
        this.format = this.fixedWidthFormat(options);
        this.settings.setFormat((Format)this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        com.univocity.parsers.fixed.FixedWidthWriter fixedWidthWriter = null;
        try {
            fixedWidthWriter = new com.univocity.parsers.fixed.FixedWidthWriter(this.writer, this.settings);
            if (this.header) {
                String[] header = new String[this.table.columnCount()];
                for (int c = 0; c < this.table.columnCount(); ++c) {
                    header[c] = this.table.column(c).name();
                }
                fixedWidthWriter.writeHeaders(header);
            }
            for (int r = 0; r < this.table.rowCount(); ++r) {
                String[] entries = new String[this.table.columnCount()];
                for (int c = 0; c < this.table.columnCount(); ++c) {
                    this.table.get(r, c);
                    entries[c] = this.table.getUnformatted(r, c);
                }
                fixedWidthWriter.writeRow(entries);
            }
        }
        finally {
            if (fixedWidthWriter != null) {
                fixedWidthWriter.flush();
                fixedWidthWriter.close();
            }
        }
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getHeader() {
        return this.header;
    }

    public FixedWidthWriterSettings getSettings() {
        return this.settings;
    }

    public FixedWidthFormat getFormat() {
        return this.format;
    }

    private FixedWidthFormat fixedWidthFormat(FixedWidthWriteOptions options) {
        FixedWidthFormat format = new FixedWidthFormat();
        if (options.padding() != ' ') {
            format.setPadding(options.padding());
        }
        if (options.lookupWildcard() != '?') {
            format.setLookupWildcard(options.lookupWildcard());
        }
        if (options.comment() != '#') {
            format.setComment(options.comment());
        }
        if (options.lineSeparator() != null) {
            format.setLineSeparator(options.lineSeparator());
        }
        if (options.lineSeparatorString() != null) {
            format.setLineSeparator(options.lineSeparatorString());
        }
        if (options.normalizedNewline() != '\n') {
            format.setNormalizedNewline(options.normalizedNewline());
        }
        return format;
    }

    private FixedWidthWriterSettings fixedWidthWriterSettings(FixedWidthWriteOptions options) {
        FixedWidthWriterSettings settings = new FixedWidthWriterSettings();
        if (options.autoConfigurationEnabled()) {
            settings.setAutoConfigurationEnabled(options.autoConfigurationEnabled());
        } else {
            this.columnRowSettings(settings, options);
            this.errorSettings(settings, options);
            this.skipIgnoreSettings(settings, options);
        }
        return settings;
    }

    private void columnRowSettings(FixedWidthWriterSettings settings, FixedWidthWriteOptions options) {
        if (options.defaultAlignmentForHeaders() != null) {
            settings.setDefaultAlignmentForHeaders(options.defaultAlignmentForHeaders());
        }
        if (options.columnReorderingEnabled()) {
            settings.setColumnReorderingEnabled(options.columnReorderingEnabled());
        }
        if (options.expandIncompleteRows()) {
            settings.setExpandIncompleteRows(options.expandIncompleteRows());
        }
        if (!options.defaultPaddingForHeaders()) {
            settings.setUseDefaultPaddingForHeaders(options.defaultPaddingForHeaders());
        }
        if (!options.writeLineSeparatorAfterRecord()) {
            settings.setWriteLineSeparatorAfterRecord(options.writeLineSeparatorAfterRecord());
        }
    }

    private void errorSettings(FixedWidthWriterSettings settings, FixedWidthWriteOptions options) {
        if (options.errorContentLength() <= -1) {
            settings.setErrorContentLength(options.errorContentLength());
        }
        if (options.nullValue() != null) {
            settings.setNullValue(options.nullValue());
        }
        if (options.emptyValue() != null) {
            settings.setEmptyValue(options.emptyValue());
        }
    }

    private void skipIgnoreSettings(FixedWidthWriterSettings settings, FixedWidthWriteOptions options) {
        if (!options.ignoreTrailingWhitespaces()) {
            settings.setIgnoreTrailingWhitespaces(options.ignoreTrailingWhitespaces());
        }
        if (!options.ignoreLeadingWhitespaces()) {
            settings.setIgnoreLeadingWhitespaces(options.ignoreLeadingWhitespaces());
        }
        if (!options.skipBitsAsWhitespace()) {
            settings.setSkipBitsAsWhitespace(options.skipBitsAsWhitespace());
        }
        if (!options.skipEmptyLines()) {
            settings.setSkipEmptyLines(options.skipEmptyLines());
        }
    }
}

