/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.fixed;

import com.google.common.base.Strings;
import com.univocity.parsers.fixed.FixedWidthFields;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ReadOptions;

public class FixedWidthReadOptions
extends ReadOptions {
    private final ColumnType[] columnTypes;
    private final FixedWidthFields columnSpecs;
    private final String lineEnding;
    private final char padding;
    private final char lookupWildcard;
    private final boolean skipTrailingCharsUntilNewline;
    private final boolean recordEndsOnNewline;
    private final boolean skipInvalidRows;
    private final Integer maxNumberOfColumns;

    private FixedWidthReadOptions(Builder builder) {
        super(builder);
        this.columnTypes = builder.columnTypes;
        this.columnSpecs = builder.columnSpecs;
        this.padding = builder.padding;
        this.lookupWildcard = builder.lookupWildcard;
        this.skipTrailingCharsUntilNewline = builder.skipTrailingCharsUntilNewline;
        this.recordEndsOnNewline = builder.recordEndsOnNewline;
        this.skipInvalidRows = builder.skipInvalidRows;
        this.lineEnding = builder.lineEnding;
        this.maxNumberOfColumns = builder.maxNumberOfColumns;
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return new Builder(stream).tableName(tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder(reader);
        return builder.tableName(tableName);
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public Reader reader() {
        return this.reader;
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public FixedWidthFields columnSpecs() {
        return this.columnSpecs;
    }

    public String lineEnding() {
        return this.lineEnding;
    }

    public char padding() {
        return this.padding;
    }

    public char lookupWildcard() {
        return this.lookupWildcard;
    }

    public boolean skipTrailingCharsUntilNewline() {
        return this.skipTrailingCharsUntilNewline;
    }

    public boolean recordEndsOnNewline() {
        return this.recordEndsOnNewline;
    }

    public boolean skipInvalidRows() {
        return this.skipInvalidRows;
    }

    @Override
    public boolean sample() {
        return this.sample;
    }

    @Override
    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    @Override
    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    @Override
    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public Integer maxNumberOfColumns() {
        return this.maxNumberOfColumns;
    }

    public static class Builder
    extends ReadOptions.Builder {
        private FixedWidthFields columnSpecs;
        private String lineEnding;
        private char padding = (char)32;
        private char lookupWildcard = (char)63;
        private boolean skipTrailingCharsUntilNewline = false;
        private boolean recordEndsOnNewline = false;
        private boolean skipInvalidRows = false;
        private ColumnType[] columnTypes;
        private Integer maxNumberOfColumns = 10000;

        public Builder(File file) {
            super(file);
        }

        public Builder(Reader reader) {
            super(reader);
        }

        public Builder(InputStream stream) {
            super(stream);
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        @Override
        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder columnSpecs(FixedWidthFields columnSpecs) {
            this.columnSpecs = columnSpecs;
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder padding(char padding) {
            this.padding = padding;
            return this;
        }

        public Builder lookupWildcard(char lookupWildcard) {
            this.lookupWildcard = lookupWildcard;
            return this;
        }

        public Builder skipTrailingCharsUntilNewline(boolean skipTrailingCharsUntilNewline) {
            this.skipTrailingCharsUntilNewline = skipTrailingCharsUntilNewline;
            return this;
        }

        public Builder recordEndsOnNewline(boolean recordEndsOnNewline) {
            this.recordEndsOnNewline = recordEndsOnNewline;
            return this;
        }

        public Builder skipInvalidRows(boolean skipInvalidRows) {
            this.skipInvalidRows = skipInvalidRows;
            return this;
        }

        @Override
        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        @Override
        public Builder minimizeColumnSizes(boolean minimize) {
            this.minimizeColumnSizes = minimize;
            return this;
        }

        public Builder maxNumberOfColumns(Integer maxNumberOfColumns) {
            this.maxNumberOfColumns = maxNumberOfColumns;
            return this;
        }

        @Override
        public FixedWidthReadOptions build() {
            return new FixedWidthReadOptions(this);
        }
    }
}

