/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class ReadOptions {
    protected final File file;
    protected final Reader reader;
    protected final InputStream inputStream;
    protected final String tableName;
    protected final boolean sample;
    protected final String dateFormat;
    protected final String dateTimeFormat;
    protected final String timeFormat;
    protected final Locale locale;
    protected final String missingValueIndicator;

    protected ReadOptions(Builder builder) {
        int sourceCount = 0;
        if (builder.file != null) {
            ++sourceCount;
        }
        if (builder.reader != null) {
            ++sourceCount;
        }
        if (builder.inputStream != null) {
            ++sourceCount;
        }
        if (sourceCount == 0) {
            throw new IllegalArgumentException("CsvReadOptions Builder configured with no data source");
        }
        if (sourceCount > 1) {
            throw new IllegalArgumentException("CsvReadOptions Builder configured with more than one data source");
        }
        this.file = builder.file;
        this.reader = builder.reader;
        this.inputStream = builder.inputStream;
        this.tableName = builder.tableName;
        this.sample = builder.sample;
        this.dateFormat = builder.dateFormat;
        this.timeFormat = builder.timeFormat;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.missingValueIndicator = builder.missingValueIndicator;
        this.locale = builder.locale == null ? Locale.getDefault() : builder.locale;
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return new Builder(stream).tableName(tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder(reader);
        return builder.tableName(tableName);
    }

    public File file() {
        return this.file;
    }

    public Reader reader() {
        return this.reader;
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean sample() {
        return this.sample;
    }

    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    public Locale locale() {
        return this.locale;
    }

    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public static class Builder {
        protected InputStream inputStream;
        protected File file;
        protected Reader reader;
        protected String tableName = "";
        protected boolean sample = true;
        protected String dateFormat;
        protected String timeFormat;
        protected String dateTimeFormat;
        protected Locale locale;
        protected String missingValueIndicator;

        public Builder(File file) {
            this.file = file;
            this.tableName = file.getName();
        }

        public Builder(Reader reader) {
            this.reader = reader;
        }

        public Builder(InputStream stream) {
            this.inputStream = stream;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

