/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Writer;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvWriteOptions;

@Immutable
public final class CsvWriter {
    private static final String nullValue = "";
    private final Table table;
    private final boolean header;
    private final Writer writer;
    private final CsvWriterSettings settings;

    public CsvWriter(Table table, CsvWriteOptions options) {
        this.table = table;
        this.header = options.header();
        this.writer = options.writer();
        this.settings = new CsvWriterSettings();
        this.settings.setNullValue(nullValue);
        ((CsvFormat)this.settings.getFormat()).setDelimiter(options.separator());
        ((CsvFormat)this.settings.getFormat()).setQuote(options.quoteChar());
        ((CsvFormat)this.settings.getFormat()).setQuoteEscape(options.escapeChar());
        ((CsvFormat)this.settings.getFormat()).setLineSeparator(options.lineEnd());
        this.settings.setSkipEmptyLines(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        com.univocity.parsers.csv.CsvWriter csvWriter = null;
        try {
            csvWriter = new com.univocity.parsers.csv.CsvWriter(this.writer, this.settings);
            if (this.header) {
                String[] header = new String[this.table.columnCount()];
                for (int c = 0; c < this.table.columnCount(); ++c) {
                    header[c] = this.table.column(c).name();
                }
                csvWriter.writeHeaders(header);
            }
            for (int r = 0; r < this.table.rowCount(); ++r) {
                String[] entries = new String[this.table.columnCount()];
                for (int c = 0; c < this.table.columnCount(); ++c) {
                    this.table.get(r, c);
                    entries[c] = this.table.getUnformatted(r, c);
                }
                csvWriter.writeRow(entries);
            }
        }
        finally {
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
            }
        }
    }

    public String getNullValue() {
        return this.settings.getNullValue();
    }

    public Table getTable() {
        return this.table;
    }

    public char getQuoteCharacter() {
        return ((CsvFormat)this.settings.getFormat()).getQuote();
    }

    public boolean getHeader() {
        return this.header;
    }

    public char getEscapeChar() {
        return ((CsvFormat)this.settings.getFormat()).getQuoteEscape();
    }

    public char getSeparator() {
        return ((CsvFormat)this.settings.getFormat()).getDelimiter();
    }

    public String getLineEnd() {
        return new String(((CsvFormat)this.settings.getFormat()).getLineSeparator());
    }
}

