/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.time.LocalTime;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class IntIndex {
    private final Int2ObjectAVLTreeMap<IntArrayList> index;

    public IntIndex(DateColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Int2ObjectOpenHashMap tempMap = new Int2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            int value = column.getIntInternal(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Int2ObjectAVLTreeMap((Int2ObjectMap)tempMap);
    }

    public IntIndex(IntColumn column) {
        Preconditions.checkArgument((boolean)column.type().equals(ColumnType.INTEGER), (Object)"Int indexing only allowed on INTEGER numeric columns");
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Int2ObjectOpenHashMap tempMap = new Int2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            int value = column.getInt(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Int2ObjectAVLTreeMap((Int2ObjectMap)tempMap);
    }

    public IntIndex(TimeColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Int2ObjectOpenHashMap tempMap = new Int2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            int value = column.getIntInternal(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Int2ObjectAVLTreeMap((Int2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            IntIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection get(LocalTime value) {
        return this.get(PackedLocalTime.pack(value));
    }

    public Selection get(LocalDate value) {
        return this.get(PackedLocalDate.pack(value));
    }

    public Selection atLeast(int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Int2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            IntIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atLeast(LocalTime value) {
        return this.atLeast(PackedLocalTime.pack(value));
    }

    public Selection atLeast(LocalDate value) {
        return this.atLeast(PackedLocalDate.pack(value));
    }

    public Selection greaterThan(int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Int2ObjectSortedMap tail = this.index.tailMap(value + 1);
        for (IntArrayList keys : tail.values()) {
            IntIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(LocalTime value) {
        return this.greaterThan(PackedLocalTime.pack(value));
    }

    public Selection greaterThan(LocalDate value) {
        return this.greaterThan(PackedLocalDate.pack(value));
    }

    public Selection atMost(int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Int2ObjectSortedMap head = this.index.headMap(value + 1);
        for (IntArrayList keys : head.values()) {
            IntIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(LocalTime value) {
        return this.atMost(PackedLocalTime.pack(value));
    }

    public Selection atMost(LocalDate value) {
        return this.atMost(PackedLocalDate.pack(value));
    }

    public Selection lessThan(int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Int2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            IntIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(LocalTime value) {
        return this.lessThan(PackedLocalTime.pack(value));
    }

    public Selection lessThan(LocalDate value) {
        return this.lessThan(PackedLocalDate.pack(value));
    }
}

