/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import tech.tablesaw.api.BooleanColumn;

public class BooleanFormatter {
    private String trueString = "true";
    private String falseString = "false";
    private String missingString = "";

    public BooleanFormatter(String trueString, String falseString, String missingString) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.missingString = missingString;
    }

    public BooleanFormatter(String trueString, String falseString) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.missingString = "";
    }

    public BooleanFormatter(String missingString) {
        this.missingString = missingString;
    }

    public String format(Boolean value) {
        if (value == null) {
            return this.missingString;
        }
        if (value.booleanValue()) {
            return this.trueString;
        }
        return this.falseString;
    }

    public String format(byte value) {
        if (value == BooleanColumn.MISSING_VALUE) {
            return this.missingString;
        }
        if (value == 1) {
            return this.trueString;
        }
        return this.falseString;
    }

    public String toString() {
        return "BooleanFormatter{trueString='" + this.trueString + '\'' + ", falseString='" + this.falseString + '\'' + ", missingString='" + this.missingString + '\'' + '}';
    }
}

