/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.selection.Selection;

public class IntColumn
extends NumberColumn<Integer>
implements CategoricalColumn<Integer> {
    private static final IntColumnType COLUMN_TYPE = ColumnType.INTEGER;
    private final IntComparator descendingComparator = (o2, o1) -> Integer.compare(o1, o2);
    private final IntArrayList data;

    protected IntColumn(String name, IntArrayList data) {
        super(COLUMN_TYPE, name);
        this.printFormatter = NumberColumnFormatter.ints();
        this.data = data;
    }

    public static IntColumn create(String name) {
        return new IntColumn(name, new IntArrayList());
    }

    public static IntColumn create(String name, int[] arr) {
        return new IntColumn(name, new IntArrayList(arr));
    }

    public static IntColumn create(String name, int initialSize) {
        IntColumn column = new IntColumn(name, new IntArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public IntColumn createCol(String name, int initialSize) {
        return IntColumn.create(name, initialSize);
    }

    public IntColumn createCol(String name) {
        return IntColumn.create(name);
    }

    public static IntColumn indexColumn(String columnName, int size, int startsWith) {
        IntColumn indexColumn = IntColumn.create(columnName, size);
        for (int i = 0; i < size; ++i) {
            indexColumn.set(i, i + startsWith);
        }
        return indexColumn;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public static boolean valueIsMissing(int value) {
        return value == IntColumnType.missingValueIndicator();
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    public IntColumn subset(int[] rows) {
        IntColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getInt(row));
        }
        return c;
    }

    public IntColumn unique() {
        IntOpenHashSet values = new IntOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            values.add(this.getInt(i));
        }
        IntColumn column = IntColumn.create(this.name() + " Unique values");
        IntIterator intIterator = values.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            column.append(value);
        }
        return column;
    }

    public IntColumn top(int n) {
        IntArrayList top = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new IntColumn(this.name() + "[Top " + n + "]", top);
    }

    public IntColumn bottom(int n) {
        IntArrayList bottom = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new IntColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public IntColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        int[] dest = new int[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = IntColumnType.missingValueIndicator();
        }
        int[] array = this.data.toIntArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new IntColumn(this.name() + " lag(" + n + ")", new IntArrayList(dest));
    }

    public IntColumn removeMissing() {
        IntColumn result = this.copy();
        result.clear();
        IntListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            int v = iterator.nextInt();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public IntColumn append(int i) {
        this.data.add(i);
        return this;
    }

    public IntColumn append(Integer val) {
        this.append((int)val);
        return this;
    }

    @Override
    public IntColumn emptyCopy() {
        return (IntColumn)super.emptyCopy();
    }

    @Override
    public IntColumn emptyCopy(int rowSize) {
        return (IntColumn)super.emptyCopy(rowSize);
    }

    @Override
    public IntColumn copy() {
        return new IntColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.data.iterator();
    }

    public Integer[] asObjectArray() {
        Integer[] output = new Integer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getInt(i);
        }
        return output;
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return Integer.compare(o1, o2);
    }

    public IntColumn set(int i, Integer val) {
        return this.set(i, (int)val);
    }

    public IntColumn set(int i, int val) {
        this.data.set(i, val);
        return this;
    }

    public IntColumn append(Column<Integer> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        IntColumn numberColumn = (IntColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getInt(i));
        }
        return this;
    }

    public IntColumn append(Column<Integer> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((IntColumn)column).getInt(row));
    }

    public IntColumn set(int row, Column<Integer> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((IntColumn)column).getInt(sourceRow));
    }

    @Override
    public IntColumn appendMissing() {
        return this.append(IntColumnType.missingValueIndicator());
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(COLUMN_TYPE.byteSize()).putInt(this.getInt(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        IntOpenHashSet uniqueElements = new IntOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissingValue(this.getInt(i))) continue;
            uniqueElements.add(this.getInt(i));
        }
        return uniqueElements.size();
    }

    public int getInt(int row) {
        return this.data.getInt(row);
    }

    @Override
    public double getDouble(int row) {
        int value = this.data.getInt(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public boolean isMissingValue(int value) {
        return IntColumnType.isMissingValue(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getInt(rowNumber));
    }

    @Override
    public void sortAscending() {
        IntArrays.parallelQuickSort((int[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.descendingComparator);
    }

    public IntColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Integer) {
            return this.append((int)((Integer)obj));
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public IntColumn appendCell(String value) {
        try {
            return this.append(IntColumnType.DEFAULT_PARSER.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public IntColumn appendCell(String value, AbstractParser<?> parser) {
        try {
            return this.append(parser.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        int value = this.getInt(row);
        if (IntColumnType.isMissingValue(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public IntColumn inRange(int start, int end) {
        return (IntColumn)super.inRange(start, end);
    }

    @Override
    public IntColumn where(Selection selection) {
        return (IntColumn)super.where(selection);
    }

    @Override
    public IntColumn lead(int n) {
        return (IntColumn)super.lead(n);
    }

    public IntColumn setName(String name) {
        return (IntColumn)super.setName(name);
    }

    public IntColumn filter(Predicate<? super Integer> test) {
        return (IntColumn)super.filter(test);
    }

    public IntColumn sorted(Comparator<? super Integer> comp) {
        return (IntColumn)super.sorted(comp);
    }

    public IntColumn map(Function<? super Integer, ? extends Integer> fun) {
        return (IntColumn)super.map(fun);
    }

    public IntColumn min(Column<Integer> other) {
        return (IntColumn)super.min(other);
    }

    public IntColumn max(Column<Integer> other) {
        return (IntColumn)super.max(other);
    }

    public IntColumn set(Selection condition, Column<Integer> other) {
        return (IntColumn)super.set(condition, other);
    }

    public IntColumn set(Selection rowSelection, Integer newValue) {
        return (IntColumn)super.set(rowSelection, newValue);
    }

    public IntColumn first(int numRows) {
        return (IntColumn)super.first(numRows);
    }

    public IntColumn last(int numRows) {
        return (IntColumn)super.last(numRows);
    }

    public IntColumn sampleN(int n) {
        return (IntColumn)super.sampleN(n);
    }

    public IntColumn sampleX(double proportion) {
        return (IntColumn)super.sampleX(proportion);
    }

    @Override
    public LongColumn asLongColumn() {
        LongArrayList values = new LongArrayList();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int f = (Integer)intListIterator.next();
            values.add((long)f);
        }
        values.trim();
        return LongColumn.create(this.name(), values.elements());
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatArrayList values = new FloatArrayList();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            values.add((float)d);
        }
        values.trim();
        return FloatColumn.create(this.name(), values.elements());
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleArrayList values = new DoubleArrayList();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            values.add((double)d);
        }
        values.trim();
        return DoubleColumn.create(this.name(), values.elements());
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortArrayList values = new ShortArrayList();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int f = (Integer)intListIterator.next();
            values.add((short)f);
        }
        values.trim();
        return ShortColumn.create(this.name(), values.elements());
    }

    public IntColumn setMissing(int r) {
        this.set(r, IntColumnType.missingValueIndicator());
        return this;
    }
}

