/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.html.HtmlTableReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;

public class DataFrameReader {
    public Table csv(String file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(new StringReader(contents), tableName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream, String tableName) throws IOException {
        return this.csv(CsvReadOptions.builder(stream, tableName));
    }

    public Table csv(Reader reader, String tableName) throws IOException {
        return this.csv(CsvReadOptions.builder(reader, tableName));
    }

    public Table csv(CsvReadOptions.Builder options) throws IOException {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) throws IOException {
        return new CsvReader().read(options);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        return SqlResultSetReader.read(resultSet, tableName);
    }

    public Table html(String url) throws IOException {
        return this.csv(new HtmlTableReader().tableToCsv(url), url);
    }
}

