/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public class Row
implements Iterator<Row> {
    private int rowNumber;
    private final Table table;
    private final String[] columnNames;
    private final Map<String, DateColumn> dateColumnMap = new TreeMap<String, DateColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, DoubleColumn> doubleColumnMap = new TreeMap<String, DoubleColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IntColumn> intColumnMap = new TreeMap<String, IntColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, LongColumn> longColumnMap = new TreeMap<String, LongColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ShortColumn> shortColumnMap = new TreeMap<String, ShortColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, FloatColumn> floatColumnMap = new TreeMap<String, FloatColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Column<String>> stringColumnMap = new TreeMap<String, Column<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, BooleanColumn> booleanColumnMap = new TreeMap<String, BooleanColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, DateTimeColumn> dateTimeColumnMap = new TreeMap<String, DateTimeColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, TimeColumn> timeColumnMap = new TreeMap<String, TimeColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Column<?>> columnMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public Row(Table table) {
        this.table = table;
        this.columnNames = table.columnNames().toArray(new String[0]);
        this.rowNumber = -1;
        for (Column<?> column : table.columns()) {
            if (column instanceof DoubleColumn) {
                this.doubleColumnMap.put(column.name(), (DoubleColumn)column);
            }
            if (column instanceof IntColumn) {
                this.intColumnMap.put(column.name(), (IntColumn)column);
            }
            if (column instanceof ShortColumn) {
                this.shortColumnMap.put(column.name(), (ShortColumn)column);
            }
            if (column instanceof LongColumn) {
                this.longColumnMap.put(column.name(), (LongColumn)column);
            }
            if (column instanceof FloatColumn) {
                this.floatColumnMap.put(column.name(), (FloatColumn)column);
            }
            if (column instanceof BooleanColumn) {
                this.booleanColumnMap.put(column.name(), (BooleanColumn)column);
            }
            if (column instanceof StringColumn) {
                this.stringColumnMap.put(column.name(), (StringColumn)column);
            }
            if (column instanceof TextColumn) {
                this.stringColumnMap.put(column.name(), (TextColumn)column);
            }
            if (column instanceof DateColumn) {
                this.dateColumnMap.put(column.name(), (DateColumn)column);
            } else if (column instanceof DateTimeColumn) {
                this.dateTimeColumnMap.put(column.name(), (DateTimeColumn)column);
            } else if (column instanceof TimeColumn) {
                this.timeColumnMap.put(column.name(), (TimeColumn)column);
            }
            this.columnMap.put(column.name(), column);
        }
    }

    @Override
    public boolean hasNext() {
        return this.rowNumber < this.table.rowCount() - 1;
    }

    public List<String> columnNames() {
        return this.table.columnNames();
    }

    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public Row next() {
        ++this.rowNumber;
        return this;
    }

    public double getDouble(String columnName) {
        return this.doubleColumnMap.get(columnName).getDouble(this.rowNumber);
    }

    public double getDouble(int columnIndex) {
        return this.getDouble(this.columnNames[columnIndex]);
    }

    public int getInt(String columnName) {
        return this.intColumnMap.get(columnName).getInt(this.rowNumber);
    }

    public int getInt(int columnIndex) {
        return this.getInt(this.columnNames[columnIndex]);
    }

    public long getLong(String columnName) {
        return this.longColumnMap.get(columnName).getLong(this.rowNumber);
    }

    public long getLong(int columnIndex) {
        return this.getLong(this.columnNames[columnIndex]);
    }

    public short getShort(String columnName) {
        return this.shortColumnMap.get(columnName).getShort(this.rowNumber);
    }

    public short getShort(int columnIndex) {
        return this.getShort(this.columnNames[columnIndex]);
    }

    public float getFloat(String columnName) {
        return this.floatColumnMap.get(columnName).getFloat(this.rowNumber);
    }

    public float getFloat(int columnIndex) {
        return this.getFloat(this.columnNames[columnIndex]);
    }

    public String getString(String columnName) {
        return this.stringColumnMap.get(columnName).get(this.rowNumber);
    }

    public String getString(int columnIndex) {
        return this.getString(this.columnNames[columnIndex]);
    }

    public String getText(String columnName) {
        return this.stringColumnMap.get(columnName).get(this.rowNumber);
    }

    public String getText(int columnIndex) {
        return this.getString(this.columnNames[columnIndex]);
    }

    public LocalDate getDate(String columnName) {
        return this.dateColumnMap.get(columnName).get(this.rowNumber);
    }

    public LocalDate getDate(int columnIndex) {
        return this.dateColumnMap.get(this.columnNames[columnIndex]).get(this.rowNumber);
    }

    public int getPackedDate(String columnName) {
        return this.dateColumnMap.get(columnName).getIntInternal(this.rowNumber);
    }

    public int getPackedDate(int columnIndex) {
        return this.dateColumnMap.get(this.columnNames[columnIndex]).getIntInternal(this.rowNumber);
    }

    public LocalTime getTime(String columnName) {
        return this.timeColumnMap.get(columnName).get(this.rowNumber);
    }

    public LocalTime getTime(int columnIndex) {
        return this.timeColumnMap.get(this.columnNames[columnIndex]).get(this.rowNumber);
    }

    public int getPackedTime(String columnName) {
        return this.timeColumnMap.get(columnName).getIntInternal(this.rowNumber);
    }

    public int getPackedTime(int columnIndex) {
        return this.timeColumnMap.get(this.columnNames[columnIndex]).getIntInternal(this.rowNumber);
    }

    public LocalDateTime getDateTime(String columnName) {
        return ((DateTimeColumn)this.columnMap.get(columnName)).get(this.rowNumber);
    }

    public LocalDateTime getDateTime(int columnIndex) {
        return this.getDateTime(this.columnNames[columnIndex]);
    }

    public long getPackedDateTime(String columnName) {
        return this.dateTimeColumnMap.get(columnName).getLongInternal(this.rowNumber);
    }

    public long getPackedDateTime(int columnIndex) {
        return this.dateTimeColumnMap.get(this.columnNames[columnIndex]).getLongInternal(this.rowNumber);
    }

    public boolean getBoolean(String columnName) {
        return this.booleanColumnMap.get(columnName).get(this.rowNumber);
    }

    public boolean getBoolean(int columnIndex) {
        return this.getBoolean(this.columnNames[columnIndex]);
    }

    public void at(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public Object getObject(String columnName) {
        return this.columnMap.get(columnName).get(this.rowNumber);
    }

    public Object getObject(int columnIndex) {
        return this.columnMap.get(this.columnNames[columnIndex]).get(this.rowNumber);
    }

    public String toString() {
        Table t = this.table.emptyCopy();
        if (this.getRowNumber() == -1) {
            return "";
        }
        t.addRow(this);
        return t.print();
    }
}

