/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;

public class CsvReadOptions {
    private final File file;
    private final Reader reader;
    private final InputStream inputStream;
    private final String tableName;
    private final ColumnType[] columnTypes;
    private final boolean header;
    private final Character separator;
    private final String lineEnding;
    private final boolean sample;
    private final String dateFormat;
    private final String dateTimeFormat;
    private final String timeFormat;
    private final Locale locale;
    private final String missingValueIndicator;
    private final Integer maxNumberOfColumns;

    private CsvReadOptions(Builder builder) {
        this.file = builder.file;
        this.reader = builder.reader;
        this.inputStream = builder.inputStream;
        this.tableName = builder.tableName;
        this.columnTypes = builder.columnTypes;
        this.header = builder.header;
        this.separator = builder.separator;
        this.sample = builder.sample;
        this.dateFormat = builder.dateFormat;
        this.timeFormat = builder.timeFormat;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.lineEnding = builder.lineEnding;
        this.missingValueIndicator = builder.missingValueIndicator;
        this.maxNumberOfColumns = builder.maxNumberOfColumns;
        this.locale = builder.locale == null ? Locale.getDefault() : builder.locale;
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return new Builder(stream).tableName(tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder(reader);
        return builder.tableName(tableName);
    }

    public File file() {
        return this.file;
    }

    public Reader reader() {
        return this.reader;
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public String tableName() {
        return this.tableName;
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public boolean header() {
        return this.header;
    }

    public Character separator() {
        return this.separator;
    }

    public String lineEnding() {
        return this.lineEnding;
    }

    public boolean sample() {
        return this.sample;
    }

    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    public Locale locale() {
        return this.locale;
    }

    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public Integer maxNumberOfColumns() {
        return this.maxNumberOfColumns;
    }

    public static class Builder {
        private InputStream inputStream;
        private File file;
        private Reader reader;
        private String tableName = "";
        private boolean header = true;
        private Character separator = Character.valueOf(',');
        private String lineEnding;
        private boolean sample = true;
        private ColumnType[] columnTypes;
        private String dateFormat;
        private String timeFormat;
        private String dateTimeFormat;
        private Locale locale;
        private String missingValueIndicator;
        private Integer maxNumberOfColumns;

        public Builder(File file) {
            this.file = file;
            this.tableName = file.getName();
        }

        public Builder(Reader reader) {
            this.reader = reader;
        }

        public Builder(InputStream stream) {
            this.inputStream = stream;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder separator(char separator) {
            this.separator = Character.valueOf(separator);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public Builder maxNumberOfColumns(Integer maxNumberOfColumns) {
            this.maxNumberOfColumns = maxNumberOfColumns;
            return this;
        }

        public CsvReadOptions build() {
            return new CsvReadOptions(this);
        }
    }
}

