/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.io.csv.CsvReadOptions;

public class TimeParser
extends AbstractParser<LocalTime> {
    private static final DateTimeFormatter timef1 = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final DateTimeFormatter timef2 = DateTimeFormatter.ofPattern("hh:mm:ss a");
    private static final DateTimeFormatter timef3 = DateTimeFormatter.ofPattern("h:mm:ss a");
    private static final DateTimeFormatter timef4 = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final DateTimeFormatter timef5 = DateTimeFormatter.ofPattern("hh:mm a");
    private static final DateTimeFormatter timef6 = DateTimeFormatter.ofPattern("h:mm a");
    private static final DateTimeFormatter timef7 = DateTimeFormatter.ofPattern("HHmm");
    private static final DateTimeFormatter TIME_DETECTION_FORMATTER;
    private static final DateTimeFormatter DEFAULT_FORMATTER;
    private Locale locale = Locale.getDefault();
    private DateTimeFormatter formatter = DEFAULT_FORMATTER;
    private DateTimeFormatter parserFormatter = TIME_CONVERSION_FORMATTER;
    private static final DateTimeFormatter TIME_CONVERSION_FORMATTER;

    public TimeParser(ColumnType columnType) {
        super(columnType);
    }

    public TimeParser(ColumnType columnType, CsvReadOptions readOptions) {
        super(columnType);
        DateTimeFormatter readCsvFormatter = readOptions.timeFormatter();
        if (readCsvFormatter != null) {
            this.formatter = readCsvFormatter;
            this.parserFormatter = readCsvFormatter;
        }
        if (readOptions.locale() != null) {
            this.locale = readOptions.locale();
        }
        if (readOptions.missingValueIndicator() != null) {
            this.missingValueStrings = Lists.newArrayList((Object[])new String[]{readOptions.missingValueIndicator()});
        }
    }

    @Override
    public boolean canParse(String s) {
        if (this.isMissing(s)) {
            return true;
        }
        try {
            LocalTime.parse(s, this.formatter.withLocale(this.locale));
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    @Override
    public LocalTime parse(String value) {
        if (this.isMissing(value)) {
            return null;
        }
        value = Strings.padStart((String)value, (int)4, (char)'0');
        return LocalTime.parse(value, this.parserFormatter);
    }

    static {
        DEFAULT_FORMATTER = TIME_DETECTION_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).toFormatter();
        TIME_CONVERSION_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).appendOptional(timef7).toFormatter();
    }
}

