/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.numbers.IntColumnType;

public class PackedLocalDate {
    private static final int DAYS_PER_CYCLE = 146097;
    private static final long DAYS_0000_TO_1970 = 719528L;

    public static byte getDayOfMonth(int date) {
        return (byte)date;
    }

    public static short getYear(int date) {
        byte byte1 = (byte)(date >> 24);
        byte byte2 = (byte)(date >> 16);
        return (short)((byte1 << 8) + (byte2 & 0xFF));
    }

    public static LocalDate asLocalDate(int date) {
        if (date == IntColumnType.missingValueIndicator()) {
            return null;
        }
        return LocalDate.of((int)PackedLocalDate.getYear(date), PackedLocalDate.getMonthValue(date), (int)PackedLocalDate.getDayOfMonth(date));
    }

    public static byte getMonthValue(int date) {
        return (byte)(date >> 8);
    }

    public static int pack(LocalDate date) {
        if (date == null) {
            return DateColumn.MISSING_VALUE;
        }
        return PackedLocalDate.pack((short)date.getYear(), (byte)date.getMonthValue(), (byte)date.getDayOfMonth());
    }

    public static int pack(Date date) {
        return PackedLocalDate.pack(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static int pack(short yr, byte m, byte d) {
        byte byte1 = (byte)(yr >> 8 & 0xFF);
        byte byte2 = (byte)yr;
        return Ints.fromBytes((byte)byte1, (byte)byte2, (byte)m, (byte)d);
    }

    public static int pack(int yr, int m, int d) {
        byte byte1 = (byte)(yr >> 8 & 0xFF);
        byte byte2 = (byte)yr;
        return Ints.fromBytes((byte)byte1, (byte)byte2, (byte)((byte)m), (byte)((byte)d));
    }

    public static String toDateString(int date) {
        if (date == Integer.MIN_VALUE) {
            return "";
        }
        return PackedLocalDate.getYear(date) + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getMonthValue(date)), (int)2, (char)'0') + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getDayOfMonth(date)), (int)2, (char)'0');
    }

    public static int getDayOfYear(int packedDate) {
        return PackedLocalDate.getMonth(packedDate).firstDayOfYear(PackedLocalDate.isLeapYear(packedDate)) + PackedLocalDate.getDayOfMonth(packedDate) - 1;
    }

    public static boolean isLeapYear(int packedDate) {
        return IsoChronology.INSTANCE.isLeapYear(PackedLocalDate.getYear(packedDate));
    }

    public static Month getMonth(int packedDate) {
        return Month.of(PackedLocalDate.getMonthValue(packedDate));
    }

    public static int lengthOfMonth(int packedDate) {
        switch (PackedLocalDate.getMonthValue(packedDate)) {
            case 2: {
                return PackedLocalDate.isLeapYear(packedDate) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static long toEpochDay(int packedDate) {
        long y = PackedLocalDate.getYear(packedDate);
        long m = PackedLocalDate.getMonthValue(packedDate);
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(PackedLocalDate.getDayOfMonth(packedDate) - 1);
        if (m > 2L) {
            --total;
            if (!PackedLocalDate.isLeapYear(packedDate)) {
                --total;
            }
        }
        return total - 719528L;
    }

    public static DayOfWeek getDayOfWeek(int packedDate) {
        int dow0 = Math.floorMod((int)PackedLocalDate.toEpochDay(packedDate) + 3, 7);
        return DayOfWeek.of(dow0 + 1);
    }

    public static int getQuarter(int packedDate) {
        if (packedDate == DateColumn.MISSING_VALUE) {
            return -1;
        }
        Month month = PackedLocalDate.getMonth(packedDate);
        switch (month) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                return 1;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                return 2;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                return 3;
            }
        }
        return 4;
    }

    public static boolean isInQ1(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 1;
    }

    public static boolean isInQ2(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 2;
    }

    public static boolean isInQ3(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 3;
    }

    public static boolean isInQ4(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 4;
    }

    public static boolean isAfter(int packedDate, int value) {
        return packedDate > value;
    }

    public static boolean isEqualTo(int packedDate, int value) {
        return DateAndTimePredicates.isEqualTo.test(packedDate, value);
    }

    public static boolean isBefore(int packedDate, int value) {
        return DateAndTimePredicates.isLessThan.test(packedDate, value);
    }

    public static boolean isOnOrBefore(int packedDate, int value) {
        return DateAndTimePredicates.isLessThanOrEqualTo.test(packedDate, value);
    }

    public static boolean isOnOrAfter(int packedDate, int value) {
        return DateAndTimePredicates.isGreaterThanOrEqualTo.test(packedDate, value);
    }

    public static boolean isDayOfWeek(int packedDate, DayOfWeek dayOfWeek) {
        DayOfWeek dow = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == dow;
    }

    public static boolean isSunday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.SUNDAY);
    }

    public static boolean isMonday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.MONDAY);
    }

    public static boolean isTuesday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.TUESDAY);
    }

    public static boolean isWednesday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.WEDNESDAY);
    }

    public static boolean isThursday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.THURSDAY);
    }

    public static boolean isFriday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.FRIDAY);
    }

    public static boolean isSaturday(int packedDate) {
        return PackedLocalDate.isDayOfWeek(packedDate, DayOfWeek.SATURDAY);
    }

    public static boolean isFirstDayOfMonth(int packedDate) {
        return PackedLocalDate.getDayOfMonth(packedDate) == 1;
    }

    public static boolean isInJanuary(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JANUARY;
    }

    public static boolean isInFebruary(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.FEBRUARY;
    }

    public static boolean isInMarch(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.MARCH;
    }

    public static boolean isInApril(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.APRIL;
    }

    public static boolean isInMay(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.MAY;
    }

    public static boolean isInJune(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JUNE;
    }

    public static boolean isInJuly(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JULY;
    }

    public static boolean isInAugust(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.AUGUST;
    }

    public static boolean isInSeptember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.SEPTEMBER;
    }

    public static boolean isInOctober(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.OCTOBER;
    }

    public static boolean isInNovember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.NOVEMBER;
    }

    public static boolean isInDecember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.DECEMBER;
    }

    public static boolean isLastDayOfMonth(int packedDate) {
        return PackedLocalDate.getDayOfMonth(packedDate) == PackedLocalDate.lengthOfMonth(packedDate);
    }

    public static int withDayOfMonth(int dayOfMonth, int packedDate) {
        byte d = (byte)dayOfMonth;
        byte m = PackedLocalDate.getMonthValue(packedDate);
        short y = PackedLocalDate.getYear(packedDate);
        return PackedLocalDate.pack(y, m, d);
    }

    public static int withMonth(int month, int packedDate) {
        byte day = PackedLocalDate.getDayOfMonth(packedDate);
        byte _month = (byte)month;
        short year = PackedLocalDate.getYear(packedDate);
        return PackedLocalDate.pack(year, _month, day);
    }

    public static int withYear(int year, int packedDate) {
        byte day = PackedLocalDate.getDayOfMonth(packedDate);
        byte month = PackedLocalDate.getMonthValue(packedDate);
        short _year = (short)year;
        return PackedLocalDate.pack(_year, month, day);
    }

    public static int plusYears(int yearsToAdd, int packedDate) {
        if (yearsToAdd == 0) {
            return packedDate;
        }
        byte d = PackedLocalDate.getDayOfMonth(packedDate);
        byte m = PackedLocalDate.getMonthValue(packedDate);
        short y = PackedLocalDate.getYear(packedDate);
        int newYear = ChronoField.YEAR.checkValidIntValue(y + yearsToAdd);
        return PackedLocalDate.resolvePreviousValid(newYear, m, d);
    }

    public static int minusYears(int years, int packedDate) {
        return PackedLocalDate.plusYears(-years, packedDate);
    }

    public static int plusMonths(int months, int packedDate) {
        if (months == 0) {
            return packedDate;
        }
        byte d = PackedLocalDate.getDayOfMonth(packedDate);
        byte m = PackedLocalDate.getMonthValue(packedDate);
        short y = PackedLocalDate.getYear(packedDate);
        long monthCount = (long)y * 12L + (long)(m - 1);
        long calcMonths = monthCount + (long)months;
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.floorDiv((int)calcMonths, 12));
        int newMonth = Math.floorMod((int)calcMonths, 12) + 1;
        return PackedLocalDate.resolvePreviousValid(newYear, newMonth, d);
    }

    public static int minusMonths(int months, int packedDate) {
        return PackedLocalDate.plusMonths(-months, packedDate);
    }

    public static int plusWeeks(int valueToAdd, int packedDate) {
        return PackedLocalDate.plusDays(valueToAdd * 7, packedDate);
    }

    public static int minusWeeks(int valueToSubtract, int packedDate) {
        return PackedLocalDate.minusDays(valueToSubtract * 7, packedDate);
    }

    public static int plusDays(int days, int packedDate) {
        if (days == 0) {
            return packedDate;
        }
        byte d = PackedLocalDate.getDayOfMonth(packedDate);
        byte m = PackedLocalDate.getMonthValue(packedDate);
        short y = PackedLocalDate.getYear(packedDate);
        long dom = d + days;
        if (dom > 0L) {
            if (dom <= 28L) {
                return PackedLocalDate.pack(y, m, (byte)dom);
            }
            if (dom <= 59L) {
                long monthLen = PackedLocalDate.lengthOfMonth(packedDate);
                if (dom <= monthLen) {
                    return PackedLocalDate.pack(y, m, (byte)dom);
                }
                if (m < 12) {
                    return PackedLocalDate.pack(y, (byte)(m + 1), (byte)(dom - monthLen));
                }
                ChronoField.YEAR.checkValidValue(y + 1);
                return PackedLocalDate.pack((short)(y + 1), (byte)1, (byte)(dom - monthLen));
            }
        }
        long mjDay = Math.addExact(PackedLocalDate.toEpochDay(packedDate), (long)days);
        return PackedLocalDate.ofEpochDay(mjDay);
    }

    public static int minusDays(int days, int packedDate) {
        return PackedLocalDate.plusDays(-days, packedDate);
    }

    public static boolean isInYear(int next, int year) {
        return PackedLocalDate.getYear(next) == year;
    }

    public static int lengthOfYear(int packedDate) {
        return PackedLocalDate.isLeapYear(packedDate) ? 366 : 365;
    }

    private static int resolvePreviousValid(int year, int month, int day) {
        switch (month) {
            case 2: {
                day = Math.min(day, IsoChronology.INSTANCE.isLeapYear(year) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                day = Math.min(day, 30);
            }
        }
        return PackedLocalDate.pack((short)year, (byte)month, (byte)day);
    }

    public static int getWeekOfYear(int packedDateTime) {
        LocalDate date = PackedLocalDate.asLocalDate(packedDateTime);
        TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        return date.get(woy);
    }

    private static int ofEpochDay(long epochDay) {
        long yearEst;
        long doyEst;
        ChronoField.EPOCH_DAY.checkValidValue(epochDay);
        long zeroDay = epochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
        return PackedLocalDate.pack((short)year, (byte)month, (byte)dom);
    }

    public static int plus(int valueToAdd, ChronoUnit unit, int packedDate) {
        switch (unit) {
            case YEARS: {
                return PackedLocalDate.plusYears(valueToAdd, packedDate);
            }
            case MONTHS: {
                return PackedLocalDate.plusMonths(valueToAdd, packedDate);
            }
            case WEEKS: {
                return PackedLocalDate.plusWeeks(valueToAdd, packedDate);
            }
            case DAYS: {
                return PackedLocalDate.plusDays(valueToAdd, packedDate);
            }
        }
        throw new RuntimeException("Unsupported Temporal Unit");
    }

    public static int minus(int valueToAdd, ChronoUnit unit, int packedDate) {
        return PackedLocalDate.plus(-valueToAdd, unit, packedDate);
    }

    public static int daysUntil(int packedDateEnd, int packedDateStart) {
        return (int)(PackedLocalDate.toEpochDay(packedDateEnd) - PackedLocalDate.toEpochDay(packedDateStart));
    }

    public static int weeksUntil(int packedDateEnd, int packedDateStart) {
        return (int)(PackedLocalDate.toEpochDay(packedDateEnd) - PackedLocalDate.toEpochDay(packedDateStart)) / 7;
    }

    public static int monthsUntil(int packedDateEnd, int packedDateStart) {
        int start = PackedLocalDate.getMonthInternal(packedDateStart) * 32 + PackedLocalDate.getDayOfMonth(packedDateStart);
        int end = PackedLocalDate.getMonthInternal(packedDateEnd) * 32 + PackedLocalDate.getDayOfMonth(packedDateEnd);
        return (end - start) / 32;
    }

    public static int yearsUntil(int packedDateEnd, int packedDateStart) {
        return PackedLocalDate.monthsUntil(packedDateEnd, packedDateStart) / 12;
    }

    private static int getMonthInternal(int packedDate) {
        return PackedLocalDate.getYear(packedDate) * 12 + PackedLocalDate.getMonthValue(packedDate) - 1;
    }
}

