/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.SkipColumnType;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.TextColumnType;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.io.csv.CsvReadOptions;

public interface ColumnType {
    public static final Map<String, ColumnType> values = new HashMap<String, ColumnType>();
    public static final ShortColumnType SHORT = ShortColumnType.INSTANCE;
    public static final IntColumnType INTEGER = IntColumnType.INSTANCE;
    public static final LongColumnType LONG = LongColumnType.INSTANCE;
    public static final FloatColumnType FLOAT = FloatColumnType.INSTANCE;
    public static final BooleanColumnType BOOLEAN = BooleanColumnType.INSTANCE;
    public static final StringColumnType STRING = StringColumnType.INSTANCE;
    public static final DoubleColumnType DOUBLE = DoubleColumnType.INSTANCE;
    public static final DateColumnType LOCAL_DATE = DateColumnType.INSTANCE;
    public static final DateTimeColumnType LOCAL_DATE_TIME = DateTimeColumnType.INSTANCE;
    public static final TimeColumnType LOCAL_TIME = TimeColumnType.INSTANCE;
    public static final TextColumnType TEXT = TextColumnType.INSTANCE;
    public static final SkipColumnType SKIP = SkipColumnType.INSTANCE;

    public static void register(ColumnType type) {
        values.put(type.name(), type);
    }

    public static ColumnType[] values() {
        return values.values().toArray(new ColumnType[0]);
    }

    public static ColumnType valueOf(String name) {
        Preconditions.checkNotNull((Object)name);
        ColumnType result = values.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name + " is not a registered column type.");
        }
        return result;
    }

    public Column<?> create(String var1);

    public String name();

    public int byteSize();

    public String getPrinterFriendlyName();

    public AbstractParser<?> customParser(CsvReadOptions var1);

    default public boolean compare(int rowNumber, Column<?> temp, Column<?> original) {
        return original.get(rowNumber).equals(temp.get(temp.size() - 1));
    }
}

