/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.Relation;

public class TableSlice
extends Relation
implements IntIterable {
    private final Selection selection;
    private String name;
    private final Table table;

    public TableSlice(Table table, Selection rowSelection) {
        this.name = table.name();
        this.selection = rowSelection;
        this.table = table;
    }

    @Override
    public Column<?> column(int columnIndex) {
        return this.table.column(columnIndex).subset(this.selection);
    }

    @Override
    public Column<?> column(String columnName) {
        return this.table.column(columnName).subset(this.selection);
    }

    private Column<?> entireColumn(int columnIndex) {
        return this.table.column(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public int rowCount() {
        return this.selection.size();
    }

    @Override
    public List<Column<?>> columns() {
        ArrayList columns = new ArrayList();
        for (int i = 0; i < this.columnCount(); ++i) {
            columns.add(this.entireColumn(i));
        }
        return columns;
    }

    @Override
    public int columnIndex(Column<?> column) {
        return this.table.columnIndex(column);
    }

    @Override
    public String get(int r, int c) {
        return this.table.get(this.selection.get(r), c);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void clear() {
        this.selection.clear();
    }

    @Override
    public List<String> columnNames() {
        return this.table.columnNames();
    }

    @Override
    public TableSlice addColumns(Column<?> ... column) {
        throw new UnsupportedOperationException("Class TableSlice does not support the addColumns operation");
    }

    @Override
    public TableSlice removeColumns(Column<?> ... columns) {
        throw new UnsupportedOperationException("Class TableSlice does not support the removeColumns operation");
    }

    @Override
    public Table first(int nRows) {
        BitmapBackedSelection newMap = new BitmapBackedSelection();
        IntIterator it = this.intIterator();
        for (int count = 0; it.hasNext() && count < nRows; ++count) {
            int row = it.nextInt();
            newMap.add(row);
        }
        return this.table.where(newMap);
    }

    @Override
    public TableSlice setName(String name) {
        this.name = name;
        return this;
    }

    public Table asTable() {
        Table table = Table.create(this.name());
        for (Column<?> column : this.columns()) {
            table.addColumns(new Column[]{column.where(this.selection)});
        }
        return table;
    }

    private IntIterator intIterator() {
        return this.selection.iterator();
    }

    public double reduce(String numberColumnName, NumericAggregateFunction function) {
        NumberColumn column = this.table.numberColumn(numberColumnName);
        return (Double)function.summarize(column.where(this.selection));
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            public int nextInt() {
                return this.i++;
            }

            public int skip(int k) {
                return this.i + k;
            }

            public boolean hasNext() {
                return this.i < TableSlice.this.rowCount();
            }
        };
    }
}

