/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.selection.Selection;

@Immutable
public class Rows {
    private Rows() {
    }

    public static void copyRowsToTable(IntArrayList rows, Table oldTable, Table newTable) {
        for (int i = 0; i < rows.size(); ++i) {
            int rowIndex = rows.getInt(i);
            int columnCount = oldTable.columnCount();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                newTable.column(columnIndex).appendObj(oldTable.column(columnIndex).get(rowIndex));
            }
        }
    }

    public static void appendRowToTable(int row, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList();
        rows.add(row);
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static boolean compareRows(int rowInOriginal, Table original, Table tempTable) {
        int columnCount = original.columnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            ColumnType columnType = original.column(columnIndex).type();
            boolean result = columnType.compare(rowInOriginal, tempTable.column(columnIndex), original.column(columnIndex));
            if (result) continue;
            return false;
        }
        return true;
    }

    public static void copyRowsToTable(Selection rows, Table oldTable, Table newTable) {
        int[] r = rows.toArray();
        IntArrayList rowArray = new IntArrayList(r);
        Rows.copyRowsToTable(rowArray, oldTable, newTable);
    }

    public static void head(int rowCount, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static void tail(int rowsToInclude, Table oldTable, Table newTable) {
        int oldTableSize = oldTable.rowCount();
        int start = oldTableSize - rowsToInclude;
        IntArrayList rows = new IntArrayList(rowsToInclude);
        for (int i = start; i < oldTableSize; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }
}

