/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import it.unimi.dsi.fastutil.doubles.Double2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class DoubleIndex {
    private final Double2ObjectAVLTreeMap<IntArrayList> index;

    public DoubleIndex(NumberColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Double2ObjectOpenHashMap tempMap = new Double2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            double value = column.getDouble(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Double2ObjectAVLTreeMap((Double2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(double value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            DoubleIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection atLeast(double value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Double2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            DoubleIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(double value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Double2ObjectSortedMap tail = this.index.tailMap(value + 1.0E-6);
        for (IntArrayList keys : tail.values()) {
            DoubleIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(double value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Double2ObjectSortedMap head = this.index.headMap(value + 1.0E-6);
        for (IntArrayList keys : head.values()) {
            DoubleIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(double value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Double2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            DoubleIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }
}

