/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import com.google.common.base.Strings;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.times.PackedLocalTime;

public interface TimeMapFunctions
extends Column<LocalTime> {
    default public NumberColumn differenceInMilliseconds(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.MILLIS);
    }

    default public NumberColumn differenceInSeconds(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.SECONDS);
    }

    default public NumberColumn differenceInMinutes(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.MINUTES);
    }

    default public NumberColumn differenceInHours(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.HOURS);
    }

    default public TimeColumn lead(int n) {
        TimeColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public TimeColumn lag(int var1);

    default public NumberColumn difference(TimeColumn column2, ChronoUnit unit) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " - " + column2.name());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            int c2 = column2.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1) || TimeColumn.valueIsMissing(c2)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            LocalTime value1 = PackedLocalTime.asLocalTime(c1);
            LocalTime value2 = PackedLocalTime.asLocalTime(c2);
            if (value1 != null && value2 != null) {
                newColumn.append(unit.between(value1, value2));
                continue;
            }
            newColumn.appendMissing();
        }
        return newColumn;
    }

    default public TimeColumn plus(int time, ChronoUnit unit) {
        TimeColumn newColumn = TimeColumn.create("");
        String timeUnitString = "";
        block6: for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumn.MISSING_VALUE);
                continue;
            }
            switch (unit) {
                case HOURS: {
                    newColumn.appendInternal(PackedLocalTime.plusHours(time, c1));
                    timeUnitString = "hours";
                    continue block6;
                }
                case MINUTES: {
                    newColumn.appendInternal(PackedLocalTime.plusMinutes(time, c1));
                    timeUnitString = "minutes";
                    continue block6;
                }
                case SECONDS: {
                    newColumn.appendInternal(PackedLocalTime.plusSeconds(time, c1));
                    timeUnitString = "seconds";
                    continue block6;
                }
                case MILLIS: {
                    newColumn.appendInternal(PackedLocalTime.plusMilliseconds(time, c1));
                    timeUnitString = "ms";
                    continue block6;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("Type " + unit + " is not currently supported");
                }
            }
        }
        newColumn.setName(this.name() + " + " + time + " " + timeUnitString + "(s)");
        return newColumn;
    }

    default public TimeColumn minus(int time, ChronoUnit unit) {
        TimeColumn newColumn = TimeColumn.create("");
        String timeUnitString = "";
        block6: for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumn.MISSING_VALUE);
                continue;
            }
            switch (unit) {
                case HOURS: {
                    newColumn.appendInternal(PackedLocalTime.minusHours(time, c1));
                    timeUnitString = "hours";
                    continue block6;
                }
                case MINUTES: {
                    newColumn.appendInternal(PackedLocalTime.minusMinutes(time, c1));
                    timeUnitString = "minutes";
                    continue block6;
                }
                case SECONDS: {
                    newColumn.appendInternal(PackedLocalTime.minusSeconds(time, c1));
                    timeUnitString = "seconds";
                    continue block6;
                }
                case MILLIS: {
                    newColumn.appendInternal(PackedLocalTime.minusMilliseconds(time, c1));
                    timeUnitString = "ms";
                    continue block6;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("Type " + unit + " is not currently supported");
                }
            }
        }
        newColumn.setName(this.name() + " - " + time + " " + timeUnitString + "(s)");
        return newColumn;
    }

    default public TimeColumn with(int time, ChronoUnit unit) {
        TimeColumn newColumn = TimeColumn.create("");
        String timeUnitString = "";
        block6: for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumn.MISSING_VALUE);
                continue;
            }
            switch (unit) {
                case HOURS: {
                    newColumn.appendInternal(PackedLocalTime.withHour(time, c1));
                    timeUnitString = "hours";
                    continue block6;
                }
                case MINUTES: {
                    newColumn.appendInternal(PackedLocalTime.withMinute(time, c1));
                    timeUnitString = "minutes";
                    continue block6;
                }
                case SECONDS: {
                    newColumn.appendInternal(PackedLocalTime.withSecond(time, c1));
                    timeUnitString = "seconds";
                    continue block6;
                }
                case MILLIS: {
                    newColumn.appendInternal(PackedLocalTime.withMillisecond(time, c1));
                    timeUnitString = "ms";
                    continue block6;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("Type " + unit + " is not currently supported");
                }
            }
        }
        newColumn.setName(this.name() + " with " + time + " " + timeUnitString + "(s)");
        return newColumn;
    }

    default public TimeColumn withHour(int hours) {
        return this.with(hours, ChronoUnit.HOURS);
    }

    default public TimeColumn plusHours(int hours) {
        return this.plus(hours, ChronoUnit.HOURS);
    }

    default public TimeColumn withMinute(int minutes) {
        return this.with(minutes, ChronoUnit.MINUTES);
    }

    default public TimeColumn plusMinutes(int minutes) {
        return this.plus(minutes, ChronoUnit.MINUTES);
    }

    default public TimeColumn withSecond(int seconds) {
        return this.with(seconds, ChronoUnit.SECONDS);
    }

    default public TimeColumn plusSeconds(int seconds) {
        return this.plus(seconds, ChronoUnit.SECONDS);
    }

    default public TimeColumn withMillisecond(int millis) {
        return this.with(millis, ChronoUnit.MILLIS);
    }

    default public TimeColumn plusMilliseconds(int millis) {
        return this.plus(millis, ChronoUnit.MILLIS);
    }

    default public TimeColumn minusHours(int hours) {
        return this.minus(hours, ChronoUnit.HOURS);
    }

    default public TimeColumn minusMinutes(int minutes) {
        return this.minus(minutes, ChronoUnit.MINUTES);
    }

    default public TimeColumn minusSeconds(int seconds) {
        return this.minus(seconds, ChronoUnit.SECONDS);
    }

    default public TimeColumn minusMilliseconds(int millis) {
        return this.minus(millis, ChronoUnit.MILLIS);
    }

    default public TimeColumn truncatedTo(ChronoUnit unit) {
        TimeColumn newColumn = TimeColumn.create("");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumn.MISSING_VALUE);
                continue;
            }
            newColumn.appendInternal(PackedLocalTime.truncatedTo(unit, c1));
        }
        return newColumn;
    }

    default public NumberColumn hour() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[hour]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getHour(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn minute() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[minute]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getMinute(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn second() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[second]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getSecond(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn milliseconds() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[ms]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getMilliseconds(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn minuteOfDay() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[minute-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getMinuteOfDay(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn secondOfDay() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[second-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (!TimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalTime.getSecondOfDay(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n, LocalTime start) {
        String newColumnName = "" + n + " " + unit.toString() + " window [" + this.name() + "]";
        int packedStartTime = PackedLocalTime.pack(start);
        DoubleColumn numberColumn = DoubleColumn.create(newColumnName, this.size());
        block5: for (int i = 0; i < this.size(); ++i) {
            int packedTime = this.getIntInternal(i);
            switch (unit) {
                case HOURS: {
                    int result = PackedLocalTime.hoursUntil(packedTime, packedStartTime) / n;
                    numberColumn.append(result);
                    continue block5;
                }
                case MINUTES: {
                    int result = PackedLocalTime.minutesUntil(packedTime, packedStartTime) / n;
                    numberColumn.append(result);
                    continue block5;
                }
                case SECONDS: {
                    int result = PackedLocalTime.secondsUntil(packedTime, packedStartTime) / n;
                    numberColumn.append(result);
                    continue block5;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("The ChronoUnit " + unit + " is not supported for timeWindows on times");
                }
            }
        }
        numberColumn.setPrintFormatter(NumberColumnFormatter.ints());
        return numberColumn;
    }

    default public StringColumn hourMinute() {
        StringColumn newColumn = StringColumn.create(this.name() + " hour & minute");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (TimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String hm = Strings.padStart((String)String.valueOf(PackedLocalTime.getHour(c1)), (int)2, (char)'0');
            hm = hm + "-" + Strings.padStart((String)String.valueOf(PackedLocalTime.getMinute(c1)), (int)2, (char)'0');
            newColumn.append(hm);
        }
        return newColumn;
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n) {
        return this.timeWindow(unit, n, this.min());
    }

    @Override
    public LocalTime get(int var1);

    public int getIntInternal(int var1);

    public LocalTime min();
}

