/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.numbers.DoubleIterable;

public interface NumberMapFunctions
extends DoubleIterable {
    default public DoubleColumn normalize() {
        double[] result = StatUtils.normalize((double[])this.asDoubleArray());
        return DoubleColumn.create(this.name() + " normalized", result);
    }

    public String name();

    public int size();

    public boolean isEmpty();

    public double[] asDoubleArray();

    default public DoubleColumn asRatio() {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " percents");
        double total = this.sum();
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (total != 0.0) {
                pctColumn.append((double)((float)value) / total);
                continue;
            }
            pctColumn.append(NumberColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    public double sum();

    default public DoubleColumn asPercent() {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " percents");
        double total = this.sum();
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (total != 0.0) {
                pctColumn.append((double)((float)value) / total * 100.0);
                continue;
            }
            pctColumn.append(NumberColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    default public DoubleColumn subtract(NumberColumn column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " - " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(this.subtract(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn add(NumberColumn column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " + " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(this.add(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn multiply(NumberColumn column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " * " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(this.multiply(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn divide(NumberColumn column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " / " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(this.divide(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn add(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " + " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.add(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn subtract(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " - " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.subtract(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn divide(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " / " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.divide(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn multiply(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " * " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.multiply(this.getDouble(i), val));
        }
        return result;
    }

    default public double add(double val1, double val2) {
        if (NumberColumn.valueIsMissing(val1) || NumberColumn.valueIsMissing(val2)) {
            return NumberColumn.MISSING_VALUE;
        }
        return val1 + val2;
    }

    default public double multiply(double val1, double val2) {
        if (NumberColumn.valueIsMissing(val1) || NumberColumn.valueIsMissing(val2)) {
            return NumberColumn.MISSING_VALUE;
        }
        return val1 * val2;
    }

    default public double divide(double val1, double val2) {
        if (NumberColumn.valueIsMissing(val1) || NumberColumn.valueIsMissing(val2)) {
            return NumberColumn.MISSING_VALUE;
        }
        return val1 / val2;
    }

    default public double subtract(double val1, double val2) {
        if (NumberColumn.valueIsMissing(val1) || NumberColumn.valueIsMissing(val2)) {
            return NumberColumn.MISSING_VALUE;
        }
        return val1 - val2;
    }

    default public DoubleColumn power(double power) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[pow]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.pow(value, power));
        }
        return newColumn;
    }

    default public DoubleColumn square() {
        DoubleColumn newColumn = this.power(2.0);
        newColumn.setName(this.name() + "[sq]");
        return newColumn;
    }

    default public DoubleColumn sqrt() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[sqrt]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.sqrt(value));
        }
        return newColumn;
    }

    default public DoubleColumn cubeRoot() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cbrt]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.cbrt(value));
        }
        return newColumn;
    }

    default public DoubleColumn cube() {
        DoubleColumn newColumn = this.power(3.0);
        newColumn.setName(this.name() + "[cb]");
        return newColumn;
    }

    default public DoubleColumn remainder(NumberColumn column2) {
        DoubleColumn result = DoubleColumn.create(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            double val1 = this.getDouble(r);
            double val2 = column2.getDouble(r);
            if (NumberColumn.valueIsMissing(val1) || NumberColumn.valueIsMissing(val2)) {
                result.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            result.append(this.getDouble(r) % column2.getDouble(r));
        }
        return result;
    }

    default public DoubleColumn logN() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[logN]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.log(value));
        }
        return newColumn;
    }

    default public DoubleColumn log10() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[log10]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.log10(value));
        }
        return newColumn;
    }

    default public DoubleColumn log1p() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[1og1p]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.log1p(value));
        }
        return newColumn;
    }

    default public DoubleColumn round() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[rounded]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.round(value));
        }
        return newColumn;
    }

    default public DoubleColumn roundInt() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[rounded]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append((int)Math.round(value));
        }
        return newColumn;
    }

    default public DoubleColumn abs() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[abs]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(Math.abs(value));
        }
        return newColumn;
    }

    default public DoubleColumn neg() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[neg]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            newColumn.append(value * -1.0);
        }
        return newColumn;
    }

    default public DoubleColumn difference() {
        DoubleColumn returnValue = DoubleColumn.create(this.name(), this.size());
        if (this.isEmpty()) {
            return returnValue;
        }
        returnValue.append(NumberColumn.MISSING_VALUE);
        for (int current = 1; current < this.size(); ++current) {
            returnValue.append(this.subtract(this.getDouble(current), this.getDouble(current - 1)));
        }
        return returnValue;
    }

    default public DoubleColumn cumSum() {
        double total = 0.0;
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cumSum]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (NumberColumn.valueIsMissing(value)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(total += value);
        }
        return newColumn;
    }

    default public DoubleColumn cumProd() {
        double total = 1.0;
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cumProd]", this.size());
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (NumberColumn.valueIsMissing(value)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(total *= value);
        }
        return newColumn;
    }

    default public DoubleColumn pctChange() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[pctChange]", this.size());
        newColumn.append(NumberColumn.MISSING_VALUE);
        for (int i = 1; i < this.size(); ++i) {
            newColumn.append(this.getDouble(i) / this.getDouble(i - 1) - 1.0);
        }
        return newColumn;
    }

    default public DoubleColumn bin(int binCount) {
        double[] histogram = new double[binCount];
        EmpiricalDistribution distribution = new EmpiricalDistribution(binCount);
        distribution.load(this.asDoubleArray());
        int k = 0;
        for (SummaryStatistics stats : distribution.getBinStats()) {
            histogram[k++] = stats.getN();
        }
        return DoubleColumn.create(this.name() + "[binned]", histogram);
    }

    public double getDouble(int var1);
}

