/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;

public interface DateMapFunctions
extends Column<LocalDate> {
    public static String dateColumnName(Column<LocalDate> column1, int value, TemporalUnit unit) {
        return column1.name() + ": " + value + " " + unit.toString() + "(s)";
    }

    default public NumberColumn daysUntil(DateColumn column2) {
        return this.timeUntil(column2, ChronoUnit.DAYS);
    }

    default public NumberColumn weeksUntil(DateColumn column2) {
        return this.timeUntil(column2, ChronoUnit.WEEKS);
    }

    default public NumberColumn monthsUntil(DateColumn column2) {
        return this.timeUntil(column2, ChronoUnit.MONTHS);
    }

    default public NumberColumn yearsUntil(DateColumn column2) {
        return this.timeUntil(column2, ChronoUnit.YEARS);
    }

    default public NumberColumn dayOfMonth() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getDayOfMonth(c1));
        }
        return newColumn;
    }

    default public NumberColumn dayOfYear() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of year");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDate.getDayOfYear(c1));
        }
        return newColumn;
    }

    default public NumberColumn monthValue() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getMonthValue(c1));
        }
        return newColumn;
    }

    default public StringColumn month() {
        StringColumn newColumn = StringColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getMonth(c1).name());
        }
        return newColumn;
    }

    default public NumberColumn year() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " year");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getYear(c1));
        }
        return newColumn;
    }

    default public StringColumn yearQuarter() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & quarter");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String yq = String.valueOf(PackedLocalDate.getYear(c1));
            yq = yq + "-" + Strings.padStart((String)String.valueOf(PackedLocalDate.getQuarter(c1)), (int)2, (char)'0');
            newColumn.append(yq);
        }
        return newColumn;
    }

    default public StringColumn yearMonth() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDate.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDate.getMonthValue(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn yearDay() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDate.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDate.getDayOfYear(c1)), (int)3, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn yearWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDate.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDate.getWeekOfYear(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public NumberColumn dayOfWeekValue() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.set(r, NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDate.getDayOfWeek(c1).getValue());
        }
        return newColumn;
    }

    default public StringColumn dayOfWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " day of week");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getDayOfWeek(c1).toString());
        }
        return newColumn;
    }

    default public NumberColumn timeUntil(DateColumn end, ChronoUnit unit) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " - " + end.name());
        block6: for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            int c2 = end.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1) || DateColumn.valueIsMissing(c2)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            switch (unit) {
                case DAYS: {
                    newColumn.append(PackedLocalDate.daysUntil(c2, c1));
                    continue block6;
                }
                case WEEKS: {
                    newColumn.append(PackedLocalDate.weeksUntil(c2, c1));
                    continue block6;
                }
                case MONTHS: {
                    newColumn.append(PackedLocalDate.monthsUntil(c2, c1));
                    continue block6;
                }
                case YEARS: {
                    newColumn.append(PackedLocalDate.yearsUntil(c2, c1));
                    continue block6;
                }
                default: {
                    LocalDate value1 = PackedLocalDate.asLocalDate(c1);
                    LocalDate value2 = PackedLocalDate.asLocalDate(c2);
                    if (value1 == null || value2 == null) {
                        newColumn.appendMissing();
                        continue block6;
                    }
                    newColumn.append(unit.between(value1, value2));
                }
            }
        }
        return newColumn;
    }

    default public DateColumn plusDays(int days) {
        return this.plus(days, ChronoUnit.DAYS);
    }

    default public DateColumn plusWeeks(int weeks) {
        return this.plus(weeks, ChronoUnit.WEEKS);
    }

    default public DateColumn plusYears(int years) {
        return this.plus(years, ChronoUnit.YEARS);
    }

    default public DateColumn plusMonths(int months) {
        return this.plus(months, ChronoUnit.MONTHS);
    }

    default public DateColumn minusDays(int days) {
        return this.plusDays(-days);
    }

    default public DateColumn minusWeeks(int weeks) {
        return this.plusWeeks(-weeks);
    }

    default public DateColumn minusYears(int years) {
        return this.plusYears(-years);
    }

    default public DateColumn minusMonths(int months) {
        return this.plusMonths(-months);
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n, LocalDate start) {
        String newColumnName = "" + n + " " + unit.toString() + " window [" + this.name() + "]";
        int packedStartDate = PackedLocalDate.pack(start);
        DoubleColumn numberColumn = DoubleColumn.create(newColumnName, this.size());
        block6: for (int i = 0; i < this.size(); ++i) {
            int packedDate = this.getIntInternal(i);
            switch (unit) {
                case DAYS: {
                    int result = PackedLocalDate.daysUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block6;
                }
                case WEEKS: {
                    int result = PackedLocalDate.weeksUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block6;
                }
                case MONTHS: {
                    int result = PackedLocalDate.monthsUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block6;
                }
                case YEARS: {
                    int result = PackedLocalDate.yearsUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block6;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("The ChronoUnit " + unit + " is not supported for timeWindows on dates");
                }
            }
        }
        numberColumn.setPrintFormatter(NumberColumnFormatter.ints());
        return numberColumn;
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n) {
        return this.timeWindow(unit, n, this.min());
    }

    default public DateColumn plus(int value, ChronoUnit unit) {
        DateColumn newColumn = DateColumn.create(DateMapFunctions.dateColumnName(this, value, unit));
        DateColumn column1 = (DateColumn)this;
        for (int r = 0; r < column1.size(); ++r) {
            int packedDate = column1.getIntInternal(r);
            if (packedDate == DateColumn.MISSING_VALUE) {
                newColumn.appendInternal(DateColumn.MISSING_VALUE);
                continue;
            }
            newColumn.appendInternal(PackedLocalDate.plus(value, unit, packedDate));
        }
        return newColumn;
    }

    default public DateColumn minus(int value, ChronoUnit unit) {
        return this.plus(-value, unit);
    }

    default public DateTimeColumn atStartOfDay() {
        DateTimeColumn newColumn = DateTimeColumn.create(this.name() + "  start");
        for (int r = 0; r < this.size(); ++r) {
            LocalDate c1 = this.get(r);
            if (c1 == null) {
                newColumn.appendInternal(DateTimeColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(c1.atStartOfDay());
        }
        return newColumn;
    }

    default public DateTimeColumn atTime(LocalTime time) {
        Preconditions.checkNotNull((Object)time);
        DateTimeColumn newColumn = DateTimeColumn.create(this.name() + " " + time.toString());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(DateTimeColumn.MISSING_VALUE);
                continue;
            }
            LocalDate value1 = PackedLocalDate.asLocalDate(c1);
            newColumn.appendInternal(PackedLocalDateTime.pack(value1, time));
        }
        return newColumn;
    }

    default public DateTimeColumn atTime(TimeColumn timeColumn) {
        DateTimeColumn newColumn = DateTimeColumn.create(this.name() + " " + timeColumn.name());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            int c2 = timeColumn.getIntInternal(r);
            if (DateColumn.valueIsMissing(c1) || DateColumn.valueIsMissing(c2)) {
                newColumn.appendInternal(DateTimeColumn.MISSING_VALUE);
                continue;
            }
            newColumn.appendInternal(PackedLocalDateTime.create(c1, c2));
        }
        return newColumn;
    }

    public int getIntInternal(int var1);

    @Override
    public LocalDate get(int var1);

    public LocalDate min();

    public LocalDate max();
}

