/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.SelectionTableSliceGroup;
import tech.tablesaw.table.StandardTableSliceGroup;
import tech.tablesaw.table.TableSliceGroup;

public class Summarizer {
    private final Table original;
    private final Table temp;
    private final List<String> summarizedColumns = new ArrayList<String>();
    private final AggregateFunction<?, ?>[] reductions;

    public Summarizer(Table sourceTable, Column<?> column, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, List<String> columnNames, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        for (String nm : columnNames) {
            tempTable.addColumns(new Column[]{sourceTable.column(nm)});
        }
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.addAll(columnNames);
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, Column<?> column3, Column<?> column4, AggregateFunction<?, ?> ... functions) {
        Preconditions.checkArgument((!sourceTable.isEmpty() ? 1 : 0) != 0, (Object)"The table to summarize is empty.");
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        tempTable.addColumns(new Column[]{column3});
        tempTable.addColumns(new Column[]{column4});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.summarizedColumns.add(column3.name());
        this.summarizedColumns.add(column4.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, Column<?> column3, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        tempTable.addColumns(new Column[]{column3});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.summarizedColumns.add(column3.name());
        this.reductions = functions;
    }

    public Table by(String ... columnNames) {
        for (String columnName : columnNames) {
            if (!this.tableDoesNotContain(columnName, this.temp)) continue;
            this.temp.addColumns(new Column[]{this.original.column(columnName)});
        }
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, columnNames);
        return this.summarize(group);
    }

    private boolean tableDoesNotContain(String columnName, Table table) {
        List upperCase = table.columnNames().stream().map(String::toUpperCase).collect(Collectors.toList());
        return !upperCase.contains(columnName.toUpperCase());
    }

    public Table by(CategoricalColumn<?> ... columns) {
        for (CategoricalColumn<?> c : columns) {
            if (this.temp.containsColumn(c)) continue;
            this.temp.addColumns(new Column[]{c});
        }
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, columns);
        return this.summarize(group);
    }

    public Table by(String groupNameTemplate, int step) {
        SelectionTableSliceGroup group = SelectionTableSliceGroup.create(this.temp, groupNameTemplate, step);
        return this.summarize(group);
    }

    public Table apply() {
        ArrayList<Table> results = new ArrayList<Table>();
        ArrayListMultimap<String, AggregateFunction<?, ?>> reductionMultimap = this.getAggregateFunctionMultimap();
        for (String name : reductionMultimap.keys()) {
            List reductions = reductionMultimap.get((Object)name);
            Table table = TableSliceGroup.summaryTableName(this.temp);
            for (AggregateFunction function : reductions) {
                Column<?> column = this.temp.column(name);
                Object result = function.summarize(column);
                ColumnType type = function.returnType();
                Column<?> newColumn = type.create(TableSliceGroup.aggregateColumnName(name, function.functionName()));
                if (result instanceof Number) {
                    Number number = (Number)result;
                    newColumn.append(number.doubleValue());
                } else {
                    newColumn.append(result);
                }
                table.addColumns(new Column[]{newColumn});
            }
            results.add(table);
        }
        return this.combineTables(results);
    }

    private Table summarize(TableSliceGroup group) {
        ArrayList<Table> results = new ArrayList<Table>();
        ArrayListMultimap<String, AggregateFunction<?, ?>> reductionMultimap = this.getAggregateFunctionMultimap();
        for (String name : reductionMultimap.keys()) {
            List reductions = reductionMultimap.get((Object)name);
            results.add(group.aggregate(name, reductions.toArray(new AggregateFunction[0])));
        }
        return this.combineTables(results);
    }

    private ArrayListMultimap<String, AggregateFunction<?, ?>> getAggregateFunctionMultimap() {
        ArrayListMultimap reductionMultimap = ArrayListMultimap.create();
        for (String name : this.summarizedColumns) {
            Column<?> column = this.temp.column(name);
            ColumnType type = column.type();
            for (AggregateFunction<?, ?> reduction : this.reductions) {
                if (!reduction.isCompatableColumn(type)) continue;
                reductionMultimap.put((Object)name, reduction);
            }
        }
        if (reductionMultimap.isEmpty()) {
            throw new RuntimeException("None of the aggregate functions provided apply to the summarized column type(s).");
        }
        return reductionMultimap;
    }

    private Table combineTables(List<Table> tables) {
        if (tables.size() == 1) {
            return tables.get(0);
        }
        Table result = null;
        for (Table table : tables) {
            if (result == null) {
                result = table;
                continue;
            }
            for (Column<?> column : table.columns()) {
                if (!this.tableDoesNotContain(column.name(), result)) continue;
                result.addColumns(new Column[]{column});
            }
        }
        return result;
    }
}

