/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import tech.tablesaw.aggregate.BooleanAggregateFunction;
import tech.tablesaw.aggregate.BooleanCountFunction;
import tech.tablesaw.aggregate.BooleanNumericFunction;
import tech.tablesaw.aggregate.CountFunction;
import tech.tablesaw.aggregate.DateAggregateFunction;
import tech.tablesaw.aggregate.DateTimeAggregateFunction;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;

public class AggregateFunctions {
    public static DateTimeAggregateFunction earliestDateTime = new DateTimeAggregateFunction("Earliest Date-Time"){

        @Override
        public LocalDateTime summarize(DateTimeColumn column) {
            return column.min();
        }
    };
    public static DateAggregateFunction earliestDate = new DateAggregateFunction("Earliest Date"){

        @Override
        public LocalDate summarize(DateColumn column) {
            return column.min();
        }
    };
    public static DateAggregateFunction latestDate = new DateAggregateFunction("Latest Date"){

        @Override
        public LocalDate summarize(DateColumn column) {
            return column.max();
        }
    };
    public static DateTimeAggregateFunction latestDateTime = new DateTimeAggregateFunction("Latest Date-Time"){

        @Override
        public LocalDateTime summarize(DateTimeColumn column) {
            return column.max();
        }
    };
    public static BooleanCountFunction countTrue = new BooleanCountFunction("Number True"){

        @Override
        public Integer summarize(BooleanColumn column) {
            return column.countTrue();
        }
    };
    public static BooleanAggregateFunction allTrue = new BooleanAggregateFunction("All True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.all();
        }
    };
    public static BooleanAggregateFunction anyTrue = new BooleanAggregateFunction("Any True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.any();
        }
    };
    public static BooleanAggregateFunction noneTrue = new BooleanAggregateFunction("None True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.none();
        }
    };
    public static BooleanCountFunction countFalse = new BooleanCountFunction("Number False"){

        @Override
        public Integer summarize(BooleanColumn column) {
            return column.countFalse();
        }
    };
    public static BooleanNumericFunction proportionTrue = new BooleanNumericFunction("Proportion True"){

        @Override
        public Double summarize(BooleanColumn column) {
            return column.proportionTrue();
        }
    };
    public static BooleanNumericFunction proportionFalse = new BooleanNumericFunction("Proportion False"){

        @Override
        public Double summarize(BooleanColumn column) {
            return column.proportionFalse();
        }
    };
    public static NumericAggregateFunction first = new NumericAggregateFunction("First"){

        @Override
        public Double summarize(NumberColumn column) {
            return column.isEmpty() ? NumberColumn.MISSING_VALUE : column.getDouble(0);
        }
    };
    public static NumericAggregateFunction last = new NumericAggregateFunction("Last"){

        @Override
        public Double summarize(NumberColumn column) {
            return column.isEmpty() ? NumberColumn.MISSING_VALUE : column.getDouble(column.size() - 1);
        }
    };
    public static NumericAggregateFunction change = new NumericAggregateFunction("Change"){

        @Override
        public Double summarize(NumberColumn column) {
            return column.size() < 2 ? NumberColumn.MISSING_VALUE : column.getDouble(column.size() - 1) - column.getDouble(0);
        }
    };
    public static NumericAggregateFunction pctChange = new NumericAggregateFunction("Percent Change"){

        @Override
        public Double summarize(NumberColumn column) {
            return column.size() < 2 ? NumberColumn.MISSING_VALUE : (column.getDouble(column.size() - 1) - column.getDouble(0)) / column.getDouble(0);
        }
    };
    public static CountFunction countNonMissing;
    public static final CountFunction count;
    public static CountFunction countMissing;
    public static CountFunction countUnique;
    public static final NumericAggregateFunction mean;
    public static final NumericAggregateFunction sum;
    public static final NumericAggregateFunction median;
    public static final CountFunction countWithMissing;
    public static final NumericAggregateFunction quartile1;
    public static final NumericAggregateFunction quartile3;
    public static final NumericAggregateFunction percentile90;
    public static final NumericAggregateFunction percentile95;
    public static final NumericAggregateFunction percentile99;
    public static final NumericAggregateFunction range;
    public static final NumericAggregateFunction min;
    public static final NumericAggregateFunction max;
    public static final NumericAggregateFunction product;
    public static final NumericAggregateFunction geometricMean;
    public static final NumericAggregateFunction populationVariance;
    public static final NumericAggregateFunction quadraticMean;
    public static final NumericAggregateFunction kurtosis;
    public static final NumericAggregateFunction skewness;
    public static final NumericAggregateFunction sumOfSquares;
    public static final NumericAggregateFunction sumOfLogs;
    public static final NumericAggregateFunction variance;
    public static final NumericAggregateFunction stdDev;
    public static final NumericAggregateFunction standardDeviation;

    public static Double percentile(NumberColumn data, Double percentile) {
        return StatUtils.percentile((double[])AggregateFunctions.removeMissing(data), (double)percentile);
    }

    private static double[] removeMissing(NumberColumn column) {
        return column.removeMissing().asDoubleArray();
    }

    private static <T> Column<T> removeMissing(Column<T> column) {
        return column.removeMissing();
    }

    public static Double meanDifference(NumberColumn column1, NumberColumn column2) {
        return StatUtils.meanDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    public static Double sumDifference(NumberColumn column1, NumberColumn column2) {
        return StatUtils.sumDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    static {
        count = countNonMissing = new CountFunction("Count"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.size() - column.countMissing();
            }
        };
        countMissing = new CountFunction("Missing Values"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.countMissing();
            }
        };
        countUnique = new CountFunction("Count Unique"){

            @Override
            public Integer summarize(Column<?> doubles) {
                return AggregateFunctions.removeMissing(doubles.unique()).size();
            }
        };
        mean = new NumericAggregateFunction("Mean"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.mean((double[])AggregateFunctions.removeMissing(column));
            }
        };
        sum = new NumericAggregateFunction("Sum"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.sum((double[])AggregateFunctions.removeMissing(column));
            }
        };
        median = new NumericAggregateFunction("Median"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 50.0);
            }
        };
        countWithMissing = new CountFunction("Count (incl. missing)"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.size();
            }
        };
        quartile1 = new NumericAggregateFunction("First Quartile"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 25.0);
            }
        };
        quartile3 = new NumericAggregateFunction("Third Quartile"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 75.0);
            }
        };
        percentile90 = new NumericAggregateFunction("90th Percentile"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 90.0);
            }
        };
        percentile95 = new NumericAggregateFunction("95th Percentile"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 95.0);
            }
        };
        percentile99 = new NumericAggregateFunction("99th Percentile"){

            @Override
            public Double summarize(NumberColumn column) {
                return AggregateFunctions.percentile(column, 99.0);
            }
        };
        range = new NumericAggregateFunction("Range"){

            @Override
            public Double summarize(NumberColumn column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return StatUtils.max((double[])data) - StatUtils.min((double[])data);
            }
        };
        min = new NumericAggregateFunction("Min"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.min((double[])AggregateFunctions.removeMissing(column));
            }
        };
        max = new NumericAggregateFunction("Max"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.max((double[])AggregateFunctions.removeMissing(column));
            }
        };
        product = new NumericAggregateFunction("Product"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.product((double[])AggregateFunctions.removeMissing(column));
            }
        };
        geometricMean = new NumericAggregateFunction("Geometric Mean"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.geometricMean((double[])AggregateFunctions.removeMissing(column));
            }
        };
        populationVariance = new NumericAggregateFunction("Population Variance"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.populationVariance((double[])AggregateFunctions.removeMissing(column));
            }
        };
        quadraticMean = new NumericAggregateFunction("Quadratic Mean"){

            @Override
            public Double summarize(NumberColumn column) {
                return new DescriptiveStatistics(AggregateFunctions.removeMissing(column)).getQuadraticMean();
            }
        };
        kurtosis = new NumericAggregateFunction("Kurtosis"){

            @Override
            public Double summarize(NumberColumn column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return new Kurtosis().evaluate(data, 0, data.length);
            }
        };
        skewness = new NumericAggregateFunction("Skewness"){

            @Override
            public Double summarize(NumberColumn column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return new Skewness().evaluate(data, 0, data.length);
            }
        };
        sumOfSquares = new NumericAggregateFunction("Sum of Squares"){

            @Override
            public String functionName() {
                return "Sum of Squares";
            }

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.sumSq((double[])AggregateFunctions.removeMissing(column));
            }
        };
        sumOfLogs = new NumericAggregateFunction("Sum of Logs"){

            @Override
            public Double summarize(NumberColumn column) {
                return StatUtils.sumLog((double[])AggregateFunctions.removeMissing(column));
            }
        };
        variance = new NumericAggregateFunction("Variance"){

            @Override
            public Double summarize(NumberColumn column) {
                double[] values = AggregateFunctions.removeMissing(column);
                return StatUtils.variance((double[])values);
            }
        };
        standardDeviation = stdDev = new NumericAggregateFunction("Std. Deviation"){

            @Override
            public Double summarize(NumberColumn column) {
                return Math.sqrt(StatUtils.variance((double[])AggregateFunctions.removeMissing(column)));
            }
        };
    }
}

