/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.conversion;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NumericAttribute;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.Relation;

public class TableConverter {
    private final Relation table;

    public TableConverter(Relation table) {
        this.table = table;
    }

    public double[][] doubleMatrix() {
        return TableConverter.doubleMatrix(this.table.columns());
    }

    public double[][] doubleMatrix(int ... columnIndicies) {
        return TableConverter.doubleMatrix(this.table.columns(columnIndicies));
    }

    public double[][] doubleMatrix(String ... columnNames) {
        return TableConverter.doubleMatrix(this.table.columns(columnNames));
    }

    public float[][] floatMatrix() {
        return TableConverter.floatMatrix(this.table.columns());
    }

    public float[][] floatMatrix(int ... columnIndicies) {
        return TableConverter.floatMatrix(this.table.columns(columnIndicies));
    }

    public float[][] floatMatrix(String ... columnNames) {
        return TableConverter.floatMatrix(this.table.columns(columnNames));
    }

    public int[][] intMatrix() {
        return TableConverter.intMatrix(this.table.columns());
    }

    public int[][] intMatrix(int ... columnIndicies) {
        return TableConverter.intMatrix(this.table.columns(columnIndicies));
    }

    public int[][] intMatrix(String ... columnNames) {
        return TableConverter.intMatrix(this.table.columns(columnNames));
    }

    private static double[][] doubleMatrix(List<Column<?>> columns) {
        Preconditions.checkArgument((columns.size() >= 1 ? 1 : 0) != 0);
        int obs = columns.get(0).size();
        double[][] allVals = new double[obs][columns.size()];
        for (int r = 0; r < obs; ++r) {
            for (int c = 0; c < columns.size(); ++c) {
                allVals[r][c] = columns.get(c).getDouble(r);
            }
        }
        return allVals;
    }

    private static float[][] floatMatrix(List<Column<?>> columns) {
        Preconditions.checkArgument((columns.size() >= 1 ? 1 : 0) != 0);
        int obs = columns.get(0).size();
        float[][] allVals = new float[obs][columns.size()];
        for (int r = 0; r < obs; ++r) {
            for (int c = 0; c < columns.size(); ++c) {
                allVals[r][c] = (float)columns.get(c).getDouble(r);
            }
        }
        return allVals;
    }

    private static int[][] intMatrix(List<Column<?>> columns) {
        Preconditions.checkArgument((columns.size() >= 1 ? 1 : 0) != 0);
        int obs = columns.get(0).size();
        int[][] allVals = new int[obs][columns.size()];
        for (int r = 0; r < obs; ++r) {
            for (int c = 0; c < columns.size(); ++c) {
                allVals[r][c] = (int)columns.get(c).getDouble(r);
            }
        }
        return allVals;
    }

    public AttributeDataset smileDataset(String responseColName) {
        return this.smileDataset(this.table.column(responseColName), this.table.columns().stream().filter(c -> !c.name().equals(responseColName)).collect(Collectors.toList()));
    }

    public AttributeDataset smileDataset(int responseColIndex, int ... variablesColIndices) {
        return this.smileDataset(this.table.column(responseColIndex), this.table.columns(variablesColIndices));
    }

    public AttributeDataset smileDataset(String responseColName, String ... variablesColNames) {
        return this.smileDataset(this.table.column(responseColName), this.table.columns(variablesColNames));
    }

    private AttributeDataset smileDataset(Column<?> responseCol, List<Column<?>> variableCols) {
        AttributeDataset data = new AttributeDataset(this.table.name(), (Attribute[])variableCols.stream().map(this::colToAttribute).toArray(Attribute[]::new), this.colToAttribute(responseCol));
        int i = 0;
        while (i < responseCol.size()) {
            int r = i++;
            double[] x = variableCols.stream().mapToDouble(c -> c.getDouble(r)).toArray();
            data.add(x, responseCol.getDouble(r));
        }
        return data;
    }

    private Attribute colToAttribute(Column col) {
        return new NumericAttribute(col.name());
    }
}

