/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import com.google.common.collect.Lists;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.io.csv.CsvReadOptions;

public class DoubleStringParser
extends StringParser<Double> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    public DoubleStringParser(ColumnType columnType) {
        super(columnType);
    }

    public DoubleStringParser(DoubleColumnType doubleColumnType, CsvReadOptions readOptions) {
        super(doubleColumnType);
        if (readOptions.missingValueIndicator() != null) {
            this.missingValueStrings = Lists.newArrayList((Object[])new String[]{readOptions.missingValueIndicator()});
        }
    }

    @Override
    public boolean canParse(String s) {
        if (this.isMissing(s)) {
            return true;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Double parse(String s) {
        if (this.isMissing(s)) {
            return DoubleColumn.MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(s);
        return Double.parseDouble(matcher.replaceAll(""));
    }

    @Override
    public double parseDouble(String s) {
        if (this.isMissing(s)) {
            return DoubleColumn.MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(s);
        return Double.parseDouble(matcher.replaceAll(""));
    }
}

