/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;

public interface DateTimeMapFunctions
extends Column<LocalDateTime> {
    default public NumberColumn differenceInMilliseconds(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.MILLIS);
    }

    default public NumberColumn differenceInSeconds(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.SECONDS);
    }

    default public NumberColumn differenceInMinutes(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.MINUTES);
    }

    default public NumberColumn differenceInHours(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.HOURS);
    }

    default public NumberColumn differenceInDays(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.DAYS);
    }

    default public NumberColumn differenceInYears(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.YEARS);
    }

    default public NumberColumn difference(DateTimeColumn column2, ChronoUnit unit) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " - " + column2.name());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            long c2 = column2.getLongInternal(r);
            if (c1 == DateTimeColumn.MISSING_VALUE || c2 == DateTimeColumn.MISSING_VALUE) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(this.difference(c1, c2, unit));
        }
        return newColumn;
    }

    default public long difference(long packedLocalDateTime1, long packedLocalDateTime2, ChronoUnit unit) {
        LocalDateTime value1 = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime1);
        LocalDateTime value2 = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime2);
        return unit.between(value1, value2);
    }

    default public NumberColumn hour() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[hour]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != DateTimeColumn.MISSING_VALUE) {
                newColumn.append(PackedLocalDateTime.getHour(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn minuteOfDay() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[minute-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != DateTimeColumn.MISSING_VALUE) {
                newColumn.append((short)PackedLocalDateTime.getMinuteOfDay(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn secondOfDay() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[second-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != DateTimeColumn.MISSING_VALUE) {
                newColumn.append(PackedLocalDateTime.getSecondOfDay(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public DateTimeColumn lead(int n) {
        DateTimeColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public DateTimeColumn lag(int var1);

    default public TimeColumn time() {
        TimeColumn newColumn = TimeColumn.create(this.name() + " time");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumn.MISSING_VALUE);
                continue;
            }
            newColumn.appendInternal(PackedLocalDateTime.time(c1));
        }
        return newColumn;
    }

    default public NumberColumn monthValue() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getMonthValue(c1));
        }
        return newColumn;
    }

    default public StringColumn month() {
        StringColumn newColumn = StringColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(Month.of(PackedLocalDateTime.getMonthValue(c1)).name());
        }
        return newColumn;
    }

    default public StringColumn yearQuarter() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & quarter");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String yq = String.valueOf(PackedLocalDateTime.getYear(c1)) + "-" + PackedLocalDateTime.getQuarter(c1);
            newColumn.append(yq);
        }
        return newColumn;
    }

    default public StringColumn yearMonth() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getMonthValue(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn yearDay() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getDayOfYear(c1)), (int)3, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn hourMinute() {
        StringColumn newColumn = StringColumn.create(this.name() + " hour & minute");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String hm = Strings.padStart((String)String.valueOf(PackedLocalDateTime.getHour(c1)), (int)2, (char)'0');
            hm = hm + ":" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getMinute(c1)), (int)2, (char)'0');
            newColumn.append(hm);
        }
        return newColumn;
    }

    default public StringColumn yearWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getWeekOfYear(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public DateColumn date() {
        DateColumn newColumn = DateColumn.create(this.name() + " date");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(DateColumn.MISSING_VALUE);
                continue;
            }
            newColumn.appendInternal(PackedLocalDateTime.date(c1));
        }
        return newColumn;
    }

    default public NumberColumn year() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " year");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getYear(PackedLocalDateTime.date(c1)));
        }
        return newColumn;
    }

    default public StringColumn dayOfWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getDayOfWeek(c1).toString());
        }
        return newColumn;
    }

    default public NumberColumn dayOfWeekValue() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDateTime.getDayOfWeek(c1).getValue());
        }
        return newColumn;
    }

    default public NumberColumn dayOfYear() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of year", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDateTime.getDayOfYear(c1));
        }
        return newColumn;
    }

    default public NumberColumn dayOfMonth() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + " day of month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(NumberColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getDayOfMonth(c1));
        }
        return newColumn;
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n, LocalDateTime start) {
        String newColumnName = "" + n + " " + unit.toString() + " window [" + this.name() + "]";
        long packedStartDate = PackedLocalDateTime.pack(start);
        DoubleColumn numberColumn = DoubleColumn.create(newColumnName, this.size());
        block8: for (int i = 0; i < this.size(); ++i) {
            long packedDate = this.getLongInternal(i);
            switch (unit) {
                case MINUTES: {
                    long result = PackedLocalDateTime.minutesUntil(packedDate, packedStartDate) / (long)n;
                    numberColumn.append(result);
                    continue block8;
                }
                case HOURS: {
                    long result = PackedLocalDateTime.hoursUntil(packedDate, packedStartDate) / (long)n;
                    numberColumn.append(result);
                    continue block8;
                }
                case DAYS: {
                    long result = PackedLocalDateTime.daysUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block8;
                }
                case WEEKS: {
                    long result = PackedLocalDateTime.weeksUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block8;
                }
                case MONTHS: {
                    long result = PackedLocalDateTime.monthsUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block8;
                }
                case YEARS: {
                    long result = PackedLocalDateTime.yearsUntil(packedDate, packedStartDate) / n;
                    numberColumn.append(result);
                    continue block8;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("The ChronoUnit " + unit + " is not supported for timeWindows on dates");
                }
            }
        }
        numberColumn.setPrintFormatter(NumberColumnFormatter.ints());
        return numberColumn;
    }

    default public NumberColumn minute() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[minute]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (!DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(PackedLocalDateTime.getMinute(c1));
                continue;
            }
            newColumn.append(NumberColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public NumberColumn timeWindow(ChronoUnit unit, int n) {
        return this.timeWindow(unit, n, this.min());
    }

    @Override
    public LocalDateTime get(int var1);

    public long getLongInternal(int var1);

    public LocalDateTime min();
}

