/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Comparator;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.RollingColumn;

public interface Column<T>
extends Iterable<T>,
Comparator<T> {
    public static <T> Column<T> create(String columnName, ColumnType<T> type) {
        return type.create(columnName);
    }

    public int size();

    public Table summary();

    public Object[] asObjectArray();

    default public Column<T> subset(Selection rows) {
        Column<T> c = this.emptyCopy();
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            c.appendCell(this.getString(row));
        }
        return c;
    }

    public int countMissing();

    default public int countUnique() {
        return this.unique().size();
    }

    public Column<T> unique();

    default public Column<T> lead(int n) {
        return this.lag(-n);
    }

    public Column<T> lag(int var1);

    public String name();

    public Column<T> setName(String var1);

    public ColumnType type();

    public String getString(int var1);

    public T get(int var1);

    public double getDouble(int var1);

    public Column<T> emptyCopy();

    public Column<T> copy();

    public Column<T> emptyCopy(int var1);

    public void clear();

    public void sortAscending();

    public void sortDescending();

    public boolean isEmpty();

    public Column<T> appendCell(String var1);

    public Column<T> appendCell(String var1, StringParser var2);

    public IntComparator rowComparator();

    public Column<T> set(int var1, T var2);

    public Column<T> append(T var1);

    public Column<T> append(Column<T> var1);

    default public Column<T> first(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(0, newRowCount);
    }

    default public Column<T> last(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(this.size() - newRowCount, this.size());
    }

    default public String title() {
        return "Column: " + this.name() + '\n';
    }

    public double[] asDoubleArray();

    default public Column<T> inRange(int start, int end) {
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        Preconditions.checkArgument((end <= this.size() ? 1 : 0) != 0);
        return this.where(Selection.withRange(start, end));
    }

    default public Column<T> rows(int ... indices) {
        Preconditions.checkArgument((Ints.max((int[])indices) <= this.size() ? 1 : 0) != 0);
        return this.where(Selection.with(indices));
    }

    default public Column<T> sampleN(int n) {
        Preconditions.checkArgument((n > 0 && n < this.size() ? 1 : 0) != 0, (Object)"The number of rows sampled must be greater than 0 and less than the number of rows in the table.");
        return this.where(Selection.selectNRowsAtRandom(n, this.size()));
    }

    default public Column<T> sampleX(double proportion) {
        Preconditions.checkArgument((proportion <= 1.0 && proportion >= 0.0 ? 1 : 0) != 0, (Object)"The sample proportion must be between 0 and 1");
        int tableSize = (int)Math.round((double)this.size() * proportion);
        return this.where(Selection.selectNRowsAtRandom(tableSize, this.size()));
    }

    public Selection isMissing();

    public Selection isNotMissing();

    public int byteSize();

    public byte[] asBytes(int var1);

    default public RollingColumn rolling(int windowSize) {
        return new RollingColumn(this, windowSize);
    }

    public String getUnformattedString(int var1);

    public boolean isMissing(int var1);

    public Column<T> appendMissing();

    public Column<T> where(Selection var1);

    public Column<T> removeMissing();

    default public void doWithEach(Consumer<T> consumer) {
        for (Object t : this) {
            consumer.accept(t);
        }
    }

    default public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (int i = 0; i < this.size(); ++i) {
            builder.append(this.getString(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    default public Column<T> fillMissing(Column<T> other) {
        Column<T> newCol = this.emptyCopy();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                newCol.appendCell(other.getUnformattedString(i));
                continue;
            }
            newCol.appendCell(this.getUnformattedString(i));
        }
        return newCol;
    }

    default public Column<T> fillMissing(T defaultVal) {
        Column<T> newCol = this.emptyCopy();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                newCol.append(defaultVal);
                continue;
            }
            newCol.appendCell(this.getUnformattedString(i));
        }
        return newCol;
    }

    default public int columnWidth() {
        int width = this.name().length();
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            width = Math.max(width, StringUtils.length((CharSequence)this.getString(rowNum)));
        }
        return width;
    }
}

