/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ParsingUtils;

public final class HtmlTableWriter {
    private HtmlTableWriter() {
    }

    public static String write(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append(HtmlTableWriter.header(table.columnNames()));
        builder.append("<tbody>").append('\n');
        for (int row = 0; row < table.rowCount(); ++row) {
            builder.append(HtmlTableWriter.row(row, table));
        }
        builder.append("</tbody>");
        return builder.toString();
    }

    public static void write(Table table, OutputStream outputStream) {
        try (PrintWriter p = new PrintWriter(outputStream);){
            p.println(HtmlTableWriter.write(table));
        }
    }

    @VisibleForTesting
    private static String row(int row, Table table) {
        StringBuilder builder = new StringBuilder().append("<tr>");
        for (Column col : table.columns()) {
            builder.append("<td>").append(String.valueOf(col.getString(row))).append("</td>");
        }
        builder.append("</tr>").append('\n');
        return builder.toString();
    }

    @VisibleForTesting
    private static String header(List<String> columnNames) {
        StringBuilder builder = new StringBuilder().append("<thead>").append('\n').append("<tr>");
        for (String name : columnNames) {
            builder.append("<th>").append(ParsingUtils.splitCamelCase(ParsingUtils.splitOnUnderscore(name))).append("</th>");
        }
        builder.append("</tr>").append('\n').append("</thead>").append('\n');
        return builder.toString();
    }
}

