/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.Column;

@Immutable
public final class TypeUtils {
    private static final String missingInd1 = "NaN";
    private static final String missingInd2 = "*";
    private static final String missingInd3 = "NA";
    private static final String missingInd4 = "null";
    public static final ImmutableList<String> MISSING_INDICATORS = ImmutableList.of((Object)"NaN", (Object)"*", (Object)"NA", (Object)"null");

    private TypeUtils() {
    }

    public static Column newColumn(@Nonnull String name, @Nonnull ColumnType type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"There must be a valid name for a new column");
        Preconditions.checkArgument((type != ColumnType.SKIP ? 1 : 0) != 0, (Object)"SKIP-ped columns should be handled outside of this method.");
        return type.create(name);
    }
}

