/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvWriteOptions;
import tech.tablesaw.io.csv.CsvWriter;
import tech.tablesaw.io.html.HtmlTableWriter;

public class DataFrameWriter {
    private final Table table;

    public DataFrameWriter(Table table) {
        this.table = table;
    }

    public void csv(String file) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(file).build();
        CsvWriter.write(this.table, options);
    }

    public void csv(File file) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(file).build();
        CsvWriter.write(this.table, options);
    }

    public void csv(CsvWriteOptions options) throws IOException {
        CsvWriter.write(this.table, options);
    }

    public void csv(OutputStream stream) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(stream).build();
        CsvWriter.write(this.table, options);
    }

    public void csv(Writer writer) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(writer).build();
        CsvWriter.write(this.table, options);
    }

    public void html(OutputStream stream) {
        HtmlTableWriter.write(this.table, stream);
    }
}

