/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.TypeUtils;

public class SqlResultSetReader {
    private static final Map<Integer, ColumnType> SQL_TYPE_TO_TABLESAW_TYPE = SqlResultSetReader.initializeMap();

    private static Map<Integer, ColumnType> initializeMap() {
        return new HashMap<Integer, ColumnType>((Map<Integer, ColumnType>)new ImmutableMap.Builder().put((Object)-2, (Object)ColumnType.BOOLEAN).put((Object)16, (Object)ColumnType.BOOLEAN).put((Object)-7, (Object)ColumnType.BOOLEAN).put((Object)91, (Object)ColumnType.LOCAL_DATE).put((Object)92, (Object)ColumnType.LOCAL_TIME).put((Object)93, (Object)ColumnType.LOCAL_DATE_TIME).put((Object)3, (Object)ColumnType.DOUBLE).put((Object)8, (Object)ColumnType.DOUBLE).put((Object)6, (Object)ColumnType.DOUBLE).put((Object)2, (Object)ColumnType.DOUBLE).put((Object)7, (Object)ColumnType.DOUBLE).put((Object)4, (Object)ColumnType.DOUBLE).put((Object)5, (Object)ColumnType.DOUBLE).put((Object)-6, (Object)ColumnType.DOUBLE).put((Object)-5, (Object)ColumnType.DOUBLE).put((Object)1, (Object)ColumnType.STRING).put((Object)-1, (Object)ColumnType.STRING).put((Object)-16, (Object)ColumnType.STRING).put((Object)-15, (Object)ColumnType.STRING).put((Object)-9, (Object)ColumnType.STRING).put((Object)12, (Object)ColumnType.STRING).build());
    }

    public static void mapJdbcTypeToColumnType(Integer jdbc, ColumnType columnType) {
        SQL_TYPE_TO_TABLESAW_TYPE.put(jdbc, columnType);
    }

    public static Table read(ResultSet resultSet, String tableName) throws SQLException {
        int i;
        ResultSetMetaData metaData = resultSet.getMetaData();
        Table table = Table.create(tableName);
        for (i = 1; i <= metaData.getColumnCount(); ++i) {
            String name = metaData.getColumnName(i);
            ColumnType type = SQL_TYPE_TO_TABLESAW_TYPE.get(metaData.getColumnType(i));
            Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"No column type found for %s as specified for column %s", (int)metaData.getColumnType(i), (Object)name);
            Column newColumn = TypeUtils.newColumn(name, type);
            table.addColumns(newColumn);
        }
        while (resultSet.next()) {
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                Column column = table.column(i - 1);
                column.appendCell(resultSet.getString(i));
            }
        }
        return table;
    }
}

