/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import it.unimi.dsi.fastutil.ints.IntIterable;
import java.util.function.DoublePredicate;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.predicates.DoubleBiPredicate;
import tech.tablesaw.filtering.predicates.DoubleRangePredicate;

public interface NumberPredicates
extends Column,
IntIterable {
    public static final DoublePredicate isZero = i -> i == 0.0;
    public static final DoublePredicate isNegative = i -> i < 0.0;
    public static final DoublePredicate isPositive = i -> i > 0.0;
    public static final DoublePredicate isNonNegative = i -> i >= 0.0;
    public static final DoubleBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static final DoubleRangePredicate isBetweenExclusive = new DoubleRangePredicate(){

        @Override
        public boolean test(double valueToTest, double rangeStart, double rangeEnd) {
            return valueToTest > rangeStart && valueToTest < rangeEnd;
        }
    };
    public static final DoubleRangePredicate isBetweenInclusive = new DoubleRangePredicate(){

        @Override
        public boolean test(double valueToTest, double rangeStart, double rangeEnd) {
            return valueToTest >= rangeStart && valueToTest <= rangeEnd;
        }
    };
    public static final DoubleBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static final DoubleBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static final DoubleBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static final DoubleBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static final DoubleBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static final DoublePredicate isMissing = i -> i != i;
    public static final DoublePredicate isNotMissing = i -> i == i;
}

