/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import tech.tablesaw.api.TimeColumn;

public class PackedLocalTime {
    private static final int MIDNIGHT = PackedLocalTime.pack(LocalTime.MIDNIGHT);
    private static final int NOON = PackedLocalTime.pack(LocalTime.NOON);
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;

    public static byte getHour(int time) {
        return (byte)(time >> 24);
    }

    public static int of(int hour, int minute) {
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        return PackedLocalTime.create(hour, minute, 0, 0);
    }

    public static int of(int hour, int minute, int second) {
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        return PackedLocalTime.create(hour, minute, second, 0);
    }

    public static int of(int hour, int minute, int second, int millis) {
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        ChronoField.MILLI_OF_SECOND.checkValidValue(millis);
        return PackedLocalTime.create(hour, minute, second, millis);
    }

    public static int truncatedTo(TemporalUnit unit, int packedTime) {
        if (unit == ChronoUnit.NANOS || unit == ChronoUnit.MILLIS) {
            return packedTime;
        }
        Duration unitDur = unit.getDuration();
        if (unitDur.getSeconds() > 86400L) {
            throw new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
        }
        int hour = PackedLocalTime.getHour(packedTime);
        byte minute = PackedLocalTime.getMinute(packedTime);
        byte second = PackedLocalTime.getSecond(packedTime);
        int milli = 0;
        if (unit == ChronoUnit.DAYS) {
            hour = 0;
            minute = 0;
            second = 0;
        } else if (unit == ChronoUnit.HALF_DAYS) {
            hour = hour >= 12 ? 12 : 0;
            minute = 0;
            second = 0;
        } else if (unit == ChronoUnit.HOURS) {
            minute = 0;
            second = 0;
        } else if (unit == ChronoUnit.MINUTES) {
            second = 0;
        }
        return PackedLocalTime.create(hour, minute, second, milli);
    }

    public static int plusHours(int hoursToAdd, int packedTime) {
        if (hoursToAdd == 0) {
            return packedTime;
        }
        byte hour = PackedLocalTime.getHour(packedTime);
        int newHour = (hoursToAdd % 24 + hour + 24) % 24;
        return PackedLocalTime.create(newHour, PackedLocalTime.getMinute(packedTime), PackedLocalTime.getSecond(packedTime), PackedLocalTime.getMilliseconds(packedTime));
    }

    public static int plusMinutes(int minutesToAdd, int packedTime) {
        if (minutesToAdd == 0) {
            return packedTime;
        }
        byte hour = PackedLocalTime.getHour(packedTime);
        byte minute = PackedLocalTime.getMinute(packedTime);
        byte second = PackedLocalTime.getSecond(packedTime);
        int milli = PackedLocalTime.getMilliseconds(packedTime);
        int mofd = hour * 60 + minute;
        int newMofd = (minutesToAdd % 1440 + mofd + 1440) % 1440;
        if (mofd == newMofd) {
            return packedTime;
        }
        int newHour = newMofd / 60;
        int newMinute = newMofd % 60;
        return PackedLocalTime.create(newHour, newMinute, second, milli);
    }

    public static int plusSeconds(int secondsToAdd, int packedTime) {
        if (secondsToAdd == 0) {
            return packedTime;
        }
        byte hour = PackedLocalTime.getHour(packedTime);
        byte minute = PackedLocalTime.getMinute(packedTime);
        byte second = PackedLocalTime.getSecond(packedTime);
        int milli = PackedLocalTime.getMilliseconds(packedTime);
        int sofd = hour * 3600 + minute * 60 + second;
        int newSofd = (secondsToAdd % 86400 + sofd + 86400) % 86400;
        if (sofd == newSofd) {
            return packedTime;
        }
        int newHour = newSofd / 3600;
        int newMinute = newSofd / 60 % 60;
        int newSecond = newSofd % 60;
        return PackedLocalTime.create(newHour, newMinute, newSecond, milli);
    }

    public static int plusMilliseconds(int msToAdd, int packedTime) {
        long newNofd;
        if (msToAdd == 0) {
            return packedTime;
        }
        long nanosToAdd = msToAdd % 86400000 * 1000000;
        long nofd = PackedLocalTime.toNanoOfDay(packedTime);
        if (nofd == (newNofd = (nanosToAdd % 86400000000000L + nofd + 86400000000000L) % 86400000000000L)) {
            return packedTime;
        }
        int newHour = (int)(newNofd / 3600000000000L);
        int newMinute = (int)(newNofd / 60000000000L % 60L);
        int newSecond = (int)(newNofd / 1000000000L % 60L);
        int newNano = (int)(newNofd % 1000000000L);
        int newMilli = newNano / 1000000;
        return PackedLocalTime.create(newHour, newMinute, newSecond, newMilli);
    }

    public static int minusHours(int hoursToSubtract, int packedTime) {
        return PackedLocalTime.plusHours(-hoursToSubtract, packedTime);
    }

    public static int minusMinutes(int minutesToSubtract, int packedTime) {
        return PackedLocalTime.plusMinutes(-minutesToSubtract, packedTime);
    }

    public static int minusSeconds(int secondsToSubtract, int packedTime) {
        return PackedLocalTime.plusSeconds(-secondsToSubtract, packedTime);
    }

    public static int minusMilliseconds(int millisToSubtract, int packedTime) {
        return PackedLocalTime.plusMilliseconds(-millisToSubtract, packedTime);
    }

    public static int withHour(int hour, int packedTime) {
        if (PackedLocalTime.getHour(packedTime) == hour) {
            return packedTime;
        }
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        return PackedLocalTime.create(hour, PackedLocalTime.getMinute(packedTime), PackedLocalTime.getSecond(packedTime), PackedLocalTime.getMilliseconds(packedTime));
    }

    public static int withMinute(int minute, int packedTime) {
        if (PackedLocalTime.getMinute(packedTime) == minute) {
            return packedTime;
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        return PackedLocalTime.create(PackedLocalTime.getHour(packedTime), minute, PackedLocalTime.getSecond(packedTime), PackedLocalTime.getMilliseconds(packedTime));
    }

    public static int withSecond(int second, int packedTime) {
        if (PackedLocalTime.getSecond(packedTime) == second) {
            return packedTime;
        }
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        return PackedLocalTime.create(PackedLocalTime.getHour(packedTime), PackedLocalTime.getMinute(packedTime), second, PackedLocalTime.getMilliseconds(packedTime));
    }

    public static int withMillisecond(int milliseconds, int packedTime) {
        if (PackedLocalTime.getMilliseconds(packedTime) == milliseconds) {
            return packedTime;
        }
        ChronoField.MILLI_OF_SECOND.checkValidValue(milliseconds);
        return PackedLocalTime.create(PackedLocalTime.getHour(packedTime), PackedLocalTime.getMinute(packedTime), PackedLocalTime.getSecond(packedTime), milliseconds);
    }

    private static int create(int hour, int minute, int second, int millis) {
        byte _hour = (byte)hour;
        byte _minute = (byte)minute;
        char _millis = (char)millis;
        _millis = (char)(_millis + (char)(second * 1000));
        return PackedLocalTime.create(_hour, _minute, _millis);
    }

    public static char getMillisecondOfMinute(int time) {
        byte byte1 = (byte)(time >> 8);
        byte byte2 = (byte)time;
        return (char)(byte1 << 8 | byte2 & 0xFF);
    }

    public static int getNano(int time) {
        long millis = PackedLocalTime.getMillisecondOfMinute(time);
        millis *= 1000000L;
        byte seconds = PackedLocalTime.getSecond(time);
        long nanos = (long)seconds * 1000000000L;
        return (int)(millis -= nanos);
    }

    public static int getMilliseconds(int time) {
        long millis = PackedLocalTime.getMillisecondOfMinute(time);
        millis *= 1000000L;
        byte seconds = PackedLocalTime.getSecond(time);
        long nanos = (long)seconds * 1000000000L;
        return (int)((millis -= nanos) / 1000000L);
    }

    public static long toNanoOfDay(int time) {
        long nano = (long)PackedLocalTime.getHour(time) * 3600000000000L;
        nano += (long)PackedLocalTime.getMinute(time) * 60000000000L;
        nano += (long)PackedLocalTime.getSecond(time) * 1000000000L;
        return nano += (long)PackedLocalTime.getNano(time);
    }

    public static LocalTime asLocalTime(int time) {
        if (time == TimeColumn.MISSING_VALUE) {
            return null;
        }
        byte hourByte = (byte)(time >> 24);
        byte minuteByte = (byte)(time >> 16);
        byte millisecondByte1 = (byte)(time >> 8);
        byte millisecondByte2 = (byte)time;
        char millis = (char)(millisecondByte1 << 8 | millisecondByte2 & 0xFF);
        int second = millis / 1000;
        int nanoOfSecond = millis % 1000 * 1000000;
        return LocalTime.of(hourByte, minuteByte, second, nanoOfSecond);
    }

    public static byte getMinute(int time) {
        return (byte)(time >> 16);
    }

    public static int pack(LocalTime time) {
        if (time == null) {
            return TimeColumn.MISSING_VALUE;
        }
        byte hour = (byte)time.getHour();
        byte minute = (byte)time.getMinute();
        char millis = (char)((double)time.getNano() / 1000000.0);
        millis = (char)(millis + (char)(time.getSecond() * 1000));
        return PackedLocalTime.create(hour, minute, millis);
    }

    private static int create(byte hour, byte minute, char millis) {
        byte m1 = (byte)(millis >> 8);
        byte m2 = (byte)millis;
        return Ints.fromBytes((byte)hour, (byte)minute, (byte)m1, (byte)m2);
    }

    public static byte getSecond(int packedLocalTime) {
        return (byte)(PackedLocalTime.getMillisecondOfMinute(packedLocalTime) / 1000);
    }

    public static double getMinuteOfDay(int packedLocalTime) {
        if (packedLocalTime == TimeColumn.MISSING_VALUE) {
            return Double.NaN;
        }
        return PackedLocalTime.getHour(packedLocalTime) * 60 + PackedLocalTime.getMinute(packedLocalTime);
    }

    public static double getSecondOfDay(int packedLocalTime) {
        if (packedLocalTime == TimeColumn.MISSING_VALUE) {
            return Double.NaN;
        }
        int total = PackedLocalTime.getHour(packedLocalTime) * 60 * 60;
        total += PackedLocalTime.getMinute(packedLocalTime) * 60;
        return total += PackedLocalTime.getSecond(packedLocalTime);
    }

    public static int getMillisecondOfDay(int packedLocalTime) {
        return (int)(PackedLocalTime.toNanoOfDay(packedLocalTime) / 1000000L);
    }

    public static String toShortTimeString(int time) {
        if (time == TimeColumn.MISSING_VALUE) {
            return "";
        }
        byte hourByte = (byte)(time >> 24);
        byte minuteByte = (byte)(time >> 16);
        byte millisecondByte1 = (byte)(time >> 8);
        byte millisecondByte2 = (byte)time;
        char millis = (char)(millisecondByte1 << 8 | millisecondByte2 & 0xFF);
        int second = millis / 1000;
        return String.format("%s:%s:%s", Strings.padStart((String)Byte.toString(hourByte), (int)2, (char)'0'), Strings.padStart((String)Byte.toString(minuteByte), (int)2, (char)'0'), Strings.padStart((String)Integer.toString(second), (int)2, (char)'0'));
    }

    public static boolean isMidnight(int packedTime) {
        return packedTime == MIDNIGHT;
    }

    public static boolean isNoon(int packedTime) {
        return packedTime == NOON;
    }

    public static boolean isAfter(int packedTime, int otherPackedTime) {
        return packedTime > otherPackedTime;
    }

    public static boolean isOnOrAfter(int packedTime, int otherPackedTime) {
        return packedTime >= otherPackedTime;
    }

    public static boolean isBefore(int packedTime, int otherPackedTime) {
        return packedTime < otherPackedTime;
    }

    public static boolean isOnOrBefore(int packedTime, int otherPackedTime) {
        return packedTime <= otherPackedTime;
    }

    public static boolean isEqualTo(int packedTime, int otherPackedTime) {
        return packedTime == otherPackedTime;
    }

    public static boolean AM(int packedTime) {
        return packedTime < NOON;
    }

    public static boolean PM(int packedTime) {
        return packedTime >= NOON;
    }

    public static int hoursUntil(int packedTimeEnd, int packedTimeStart) {
        return PackedLocalTime.secondsUntil(packedTimeEnd, packedTimeStart) / 3600;
    }

    public static int minutesUntil(int packedTimeEnd, int packedTimeStart) {
        return PackedLocalTime.secondsUntil(packedTimeEnd, packedTimeStart) / 60;
    }

    public static int secondsUntil(int packedTimeEnd, int packedTimeStart) {
        return (int)(PackedLocalTime.getSecondOfDay(packedTimeEnd) - PackedLocalTime.getSecondOfDay(packedTimeStart));
    }
}

