/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;

public class PackedDateTime {
    private int index = 0;
    private final DateTimeColumn dateTimeColumn;

    public PackedDateTime(DateTimeColumn column) {
        this.dateTimeColumn = column;
    }

    PackedDateTime next() {
        ++this.index;
        return this;
    }

    public PackedDateTime get(int rowNumber) {
        this.index = rowNumber;
        return this;
    }

    public long getPackedValue() {
        return this.value();
    }

    public LocalDateTime asLocalDateTime() {
        return PackedLocalDateTime.asLocalDateTime(this.value());
    }

    public byte getDayOfMonth() {
        return PackedLocalDateTime.getDayOfMonth(this.value());
    }

    public short getYear() {
        return PackedLocalDateTime.getYear(this.value());
    }

    public byte getMonthValue() {
        return PackedLocalDateTime.getMonthValue(this.value());
    }

    public int date() {
        return PackedLocalDateTime.date(this.value());
    }

    public int time() {
        return PackedLocalDateTime.time(this.value());
    }

    public String toString() {
        return PackedLocalDateTime.toString(this.value());
    }

    public int getDayOfYear() {
        return PackedLocalDateTime.getDayOfYear(this.value());
    }

    public int getWeekOfYear() {
        return PackedLocalDateTime.getWeekOfYear(this.value());
    }

    public boolean isLeapYear() {
        return PackedLocalDateTime.isLeapYear(this.value());
    }

    public Month getMonth() {
        return PackedLocalDateTime.getMonth(this.value());
    }

    public int lengthOfMonth() {
        return PackedLocalDateTime.lengthOfMonth(this.value());
    }

    public DayOfWeek getDayOfWeek() {
        return PackedLocalDateTime.getDayOfWeek(this.value());
    }

    public int getQuarter() {
        return PackedLocalDateTime.getQuarter(this.value());
    }

    public boolean isInQ1() {
        return PackedLocalDateTime.isInQ1(this.value());
    }

    public boolean isInQ2() {
        return PackedLocalDateTime.isInQ2(this.value());
    }

    public boolean isInQ3() {
        return PackedLocalDateTime.isInQ3(this.value());
    }

    public boolean isInQ4() {
        return PackedLocalDateTime.isInQ4(this.value());
    }

    public boolean isAfter(long valueToTestAgainst) {
        return PackedLocalDateTime.isAfter(this.value(), valueToTestAgainst);
    }

    public boolean isAfter(LocalDateTime valueToTestAgainst) {
        return this.isAfter(PackedLocalDateTime.pack(valueToTestAgainst));
    }

    public boolean isBefore(long valueToTestAgainst) {
        return PackedLocalDateTime.isBefore(this.value(), valueToTestAgainst);
    }

    public boolean isBefore(LocalDateTime valueToTestAgainst) {
        return this.isBefore(PackedLocalDateTime.pack(valueToTestAgainst));
    }

    public boolean isSunday() {
        return PackedLocalDateTime.isSunday(this.value());
    }

    public boolean isMonday() {
        return PackedLocalDateTime.isMonday(this.value());
    }

    public boolean isTuesday() {
        return PackedLocalDateTime.isTuesday(this.value());
    }

    public boolean isWednesday() {
        return PackedLocalDateTime.isWednesday(this.value());
    }

    public boolean isThursday() {
        return PackedLocalDateTime.isThursday(this.value());
    }

    public boolean isFriday() {
        return PackedLocalDateTime.isFriday(this.value());
    }

    public boolean isSaturday() {
        return PackedLocalDateTime.isSaturday(this.value());
    }

    public boolean isFirstDayOfMonth() {
        return PackedLocalDateTime.isFirstDayOfMonth(this.value());
    }

    public boolean isInJanuary() {
        return PackedLocalDateTime.isInJanuary(this.value());
    }

    public boolean isInFebruary() {
        return PackedLocalDateTime.isInFebruary(this.value());
    }

    public boolean isInMarch() {
        return PackedLocalDateTime.isInMarch(this.value());
    }

    public boolean isInApril() {
        return PackedLocalDateTime.isInApril(this.value());
    }

    public boolean isInMay() {
        return PackedLocalDateTime.isInMay(this.value());
    }

    public boolean isInJune() {
        return PackedLocalDateTime.isInJune(this.value());
    }

    public boolean isInJuly() {
        return PackedLocalDateTime.isInJuly(this.value());
    }

    public boolean isInAugust() {
        return PackedLocalDateTime.isInAugust(this.value());
    }

    public boolean isInSeptember() {
        return PackedLocalDateTime.isInSeptember(this.value());
    }

    public boolean isInOctober() {
        return PackedLocalDateTime.isInOctober(this.value());
    }

    public boolean isInNovember() {
        return PackedLocalDateTime.isInNovember(this.value());
    }

    public boolean isInDecember() {
        return PackedLocalDateTime.isInDecember(this.value());
    }

    public boolean isLastDayOfMonth() {
        return PackedLocalDateTime.isLastDayOfMonth(this.value());
    }

    public boolean isInYear(int year) {
        return PackedLocalDateTime.isInYear(this.value(), year);
    }

    public boolean isMidnight() {
        return PackedLocalDateTime.isMidnight(this.value());
    }

    public boolean isNoon() {
        return PackedLocalDateTime.isNoon(this.value());
    }

    public boolean AM() {
        return PackedLocalDateTime.AM(this.value());
    }

    public boolean PM() {
        return PackedLocalDateTime.PM(this.value());
    }

    public int getMinuteOfDay() {
        return PackedLocalDateTime.getMinuteOfDay(this.value());
    }

    public byte getHour() {
        return PackedLocalDateTime.getHour(this.value());
    }

    public byte getMinute() {
        return PackedLocalDateTime.getMinute(this.value());
    }

    public byte getSecond() {
        return PackedLocalDateTime.getSecond(this.value());
    }

    public double getSecondOfDay() {
        return PackedLocalDateTime.getSecondOfDay(this.value());
    }

    public short getMillisecondOfMinute() {
        return PackedLocalDateTime.getMillisecondOfMinute(this.value());
    }

    public long getMillisecondOfDay() {
        return PackedLocalDateTime.getMillisecondOfDay(this.value());
    }

    public long toEpochMilli(ZoneOffset offset) {
        return PackedLocalDateTime.toEpochMilli(this.value(), offset);
    }

    public long ofEpochMilli(ZoneId zoneId) {
        return PackedLocalDateTime.ofEpochMilli(this.value(), zoneId);
    }

    public int lengthOfYear() {
        return PackedLocalDateTime.lengthOfYear(this.value());
    }

    public long minutesUntil(long packedDateTimeEnd) {
        return PackedLocalDateTime.minutesUntil(this.value(), packedDateTimeEnd);
    }

    public long minutesUntil(LocalDateTime packedDateTimeEnd) {
        return this.minutesUntil(PackedLocalDateTime.pack(packedDateTimeEnd));
    }

    public long hoursUntil(long packedDateTimeEnd) {
        return PackedLocalDateTime.hoursUntil(this.value(), packedDateTimeEnd);
    }

    public long hoursUntil(LocalDateTime packedDateTimeEnd) {
        return this.hoursUntil(PackedLocalDateTime.pack(packedDateTimeEnd));
    }

    public int daysUntil(long packedDateTimeEnd) {
        return PackedLocalDateTime.daysUntil(this.value(), packedDateTimeEnd);
    }

    public int daysUntil(LocalDateTime packedDateTimeEnd) {
        return this.daysUntil(PackedLocalDateTime.pack(packedDateTimeEnd));
    }

    public int weeksUntil(long packedDateTimeEnd) {
        return PackedLocalDateTime.weeksUntil(this.value(), packedDateTimeEnd);
    }

    public int weeksUntil(LocalDateTime packedDateTimeEnd) {
        return this.weeksUntil(PackedLocalDateTime.pack(packedDateTimeEnd));
    }

    public int monthsUntil(long packedDateTimeEnd) {
        return PackedLocalDateTime.monthsUntil(this.value(), packedDateTimeEnd);
    }

    public int monthsUntil(LocalDateTime packedDateTimeEnd) {
        return this.monthsUntil(PackedLocalDateTime.pack(packedDateTimeEnd));
    }

    public int yearsUntil(long packedDateEnd) {
        return PackedLocalDateTime.yearsUntil(this.value(), packedDateEnd);
    }

    public int yearsUntil(LocalDateTime packedDateEnd) {
        return this.yearsUntil(PackedLocalDateTime.pack(packedDateEnd));
    }

    public boolean isEqualTo(long value) {
        return PackedLocalDateTime.isEqualTo(this.value(), value);
    }

    public boolean isEqualTo(LocalDateTime value) {
        return this.isEqualTo(PackedLocalDateTime.pack(value));
    }

    public boolean isOnOrAfter(long valueToTestAgainst) {
        return PackedLocalDateTime.isOnOrAfter(this.value(), valueToTestAgainst);
    }

    public boolean isOnOrAfter(LocalDateTime valueToTestAgainst) {
        return this.isOnOrAfter(PackedLocalDateTime.pack(valueToTestAgainst));
    }

    public boolean isOnOrBefore(long valueToTestAgainst) {
        return PackedLocalDateTime.isOnOrBefore(this.value(), valueToTestAgainst);
    }

    public boolean isOnOrBefore(LocalDateTime valueToTestAgainst) {
        return this.isOnOrBefore(PackedLocalDateTime.pack(valueToTestAgainst));
    }

    private long value() {
        return this.dateTimeColumn.getLongInternal(this.index);
    }
}

