/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.RollingColumn;

public interface Column {
    public static Column create(String columnName, ColumnType type) {
        return type.create(columnName);
    }

    public int size();

    public Table summary();

    public Object[] asObjectArray();

    default public Column subset(Selection rows) {
        Column c = this.emptyCopy();
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            c.appendCell(this.getString(row));
        }
        return c;
    }

    default public double summarizeIf(Selection selection, AggregateFunction function) {
        Column column = this.where(selection);
        return function.summarize(column);
    }

    public int countMissing();

    default public int countUnique() {
        return this.unique().size();
    }

    public Column unique();

    default public Column lead(int n) {
        return this.lag(-n);
    }

    public Column lag(int var1);

    public String name();

    public Column setName(String var1);

    public ColumnType type();

    public String getString(int var1);

    public double getDouble(int var1);

    public Column emptyCopy();

    public Column copy();

    public Column emptyCopy(int var1);

    public void clear();

    public void sortAscending();

    public void sortDescending();

    public boolean isEmpty();

    public Column appendCell(String var1);

    public Column appendCell(String var1, StringParser var2);

    public IntComparator rowComparator();

    public void append(Column var1);

    default public Column first(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(0, newRowCount);
    }

    default public Column last(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(this.size() - newRowCount, this.size());
    }

    public String print();

    default public String title() {
        return "Column: " + this.name() + '\n';
    }

    public double[] asDoubleArray();

    public int columnWidth();

    default public Column inRange(int start, int end) {
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        Preconditions.checkArgument((end <= this.size() ? 1 : 0) != 0);
        return this.where(Selection.withRange(start, end));
    }

    default public Column rows(int ... indices) {
        Preconditions.checkArgument((Ints.max((int[])indices) <= this.size() ? 1 : 0) != 0);
        return this.where(Selection.with(indices));
    }

    default public Column sampleN(int n) {
        Preconditions.checkArgument((n > 0 && n < this.size() ? 1 : 0) != 0, (Object)"The number of rows sampled must be greater than 0 and less than the number of rows in the table.");
        return this.where(Selection.selectNRowsAtRandom(n, this.size()));
    }

    default public Column sampleX(double proportion) {
        Preconditions.checkArgument((proportion <= 1.0 && proportion >= 0.0 ? 1 : 0) != 0, (Object)"The sample proportion must be between 0 and 1");
        int tableSize = (int)Math.round((double)this.size() * proportion);
        return this.where(Selection.selectNRowsAtRandom(tableSize, this.size()));
    }

    public Selection isMissing();

    public Selection isNotMissing();

    public int byteSize();

    public byte[] asBytes(int var1);

    default public RollingColumn rolling(int windowSize) {
        return new RollingColumn(this, windowSize);
    }

    public String getUnformattedString(int var1);

    public boolean isMissing(int var1);

    public Column appendMissing();

    public Column where(Selection var1);

    public Column removeMissing();
}

