/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.strings.StringColumnFormatter;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.StringFilters;
import tech.tablesaw.columns.strings.StringMapFunctions;
import tech.tablesaw.columns.strings.StringReduceUtils;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class StringColumn
extends AbstractColumn
implements CategoricalColumn,
StringFilters,
StringMapFunctions,
StringReduceUtils {
    public static final String MISSING_VALUE = (String)((Object)ColumnType.STRING.getMissingValue());
    private final AtomicInteger nextIndex = new AtomicInteger(1);
    private IntArrayList values;
    private final DictionaryMap lookupTable = new DictionaryMap();
    private StringColumnFormatter printFormatter = new StringColumnFormatter();
    private final IntComparator rowComparator = new IntComparator(){

        public int compare(int i, int i1) {
            String f1 = StringColumn.this.get(i);
            String f2 = StringColumn.this.get(i1);
            return f1.compareTo(f2);
        }
    };
    private final IntComparator reverseDictionarySortComparator = new IntComparator(){

        public int compare(int i, int i1) {
            return -StringColumn.this.lookupTable.get(i).compareTo(StringColumn.this.lookupTable.get(i1));
        }
    };
    private final IntComparator dictionarySortComparator = new IntComparator(){

        public int compare(int i, int i1) {
            return StringColumn.this.lookupTable.get(i).compareTo(StringColumn.this.lookupTable.get(i1));
        }
    };

    public static boolean valueIsMissing(String string) {
        return MISSING_VALUE.equals(string);
    }

    @Override
    public StringColumn appendMissing() {
        this.append(MISSING_VALUE);
        return this;
    }

    public static StringColumn create(String name) {
        return StringColumn.create(name, 128);
    }

    public static StringColumn create(String name, String[] strings) {
        return StringColumn.create(name, Arrays.asList(strings));
    }

    public static StringColumn create(String name, List<String> strings) {
        return new StringColumn(name, strings);
    }

    public static StringColumn create(String name, int size) {
        return new StringColumn(name, new ArrayList<String>(size));
    }

    private StringColumn(String name, List<String> strings) {
        super(ColumnType.STRING, name);
        this.values = new IntArrayList(strings.size());
        for (String string : strings) {
            this.append(string);
        }
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.get(rowNumber).equals(MISSING_VALUE);
    }

    public void setPrintFormatter(StringColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    public StringColumnFormatter getPrintFormatter() {
        return this.printFormatter;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.get(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return String.valueOf(this.get(row));
    }

    @Override
    public StringColumn emptyCopy() {
        return StringColumn.create(this.name());
    }

    @Override
    public StringColumn emptyCopy(int rowSize) {
        return StringColumn.create(this.name(), rowSize);
    }

    @Override
    public void sortAscending() {
        int[] elements = this.values.toIntArray();
        IntArrays.parallelQuickSort((int[])elements, (IntComparator)this.dictionarySortComparator);
        this.values = new IntArrayList(elements);
    }

    @Override
    public void sortDescending() {
        int[] elements = this.values.toIntArray();
        IntArrays.parallelQuickSort((int[])elements, (IntComparator)this.reverseDictionarySortComparator);
        this.values = new IntArrayList(elements);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String get(int rowIndex) {
        int k = this.values.getInt(rowIndex);
        return this.lookupTable.get(k);
    }

    public List<String> asList() {
        ArrayList<String> strings = new ArrayList<String>();
        for (String category : this) {
            strings.add(category);
        }
        return strings;
    }

    @Override
    public Table summary() {
        return this.countByCategory();
    }

    @Override
    public Table countByCategory() {
        Table t = new Table("Column: " + this.name(), new Column[0]);
        StringColumn categories = StringColumn.create("Category");
        DoubleColumn counts = DoubleColumn.create("Count");
        Int2IntOpenHashMap valueToCount = new Int2IntOpenHashMap();
        IntListIterator intListIterator = this.values.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (valueToCount.containsKey(next)) {
                valueToCount.put(next, valueToCount.get(next) + 1);
                continue;
            }
            valueToCount.put(next, 1);
        }
        for (Map.Entry entry : valueToCount.int2IntEntrySet()) {
            categories.append(this.lookupTable.get((Integer)entry.getKey()));
            counts.append(((Integer)entry.getValue()).intValue());
        }
        if (this.countMissing() > 0) {
            categories.append("* missing values");
            counts.append(this.countMissing());
        }
        t.addColumns(categories);
        t.addColumns(counts);
        return t;
    }

    @Override
    public int[] asIntArray() {
        return this.data().toArray(new int[this.size()]);
    }

    @Override
    public void clear() {
        this.values.clear();
        this.lookupTable.clear();
    }

    @Override
    public StringColumn lead(int n) {
        StringColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    @Override
    public StringColumn lag(int n) {
        StringColumn copy = this.emptyCopy(this.size());
        copy.setName(this.name() + " lag(" + n + ")");
        if (n >= 0) {
            for (int m = 0; m < n; ++m) {
                copy.appendCell(MISSING_VALUE);
            }
            for (int i = 0; i < this.size() && i + n < this.size(); ++i) {
                copy.appendCell(this.get(i));
            }
        } else {
            for (int i = -n; i < this.size(); ++i) {
                copy.appendCell(this.get(i));
            }
            for (int m = 0; m > n; --m) {
                copy.appendCell(MISSING_VALUE);
            }
        }
        return copy;
    }

    public StringColumn set(Selection rowSelection, String newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public StringColumn set(int rowIndex, String stringValue) {
        int valueId;
        String str = MISSING_VALUE;
        if (stringValue != null) {
            str = stringValue;
        }
        if ((valueId = this.lookupTable.get(str)) <= 0) {
            valueId = this.nextIndex.getAndIncrement();
            this.lookupTable.put(valueId, str);
        }
        this.values.set(rowIndex, valueId);
        return this;
    }

    @Override
    public int countUnique() {
        return this.lookupTable.size();
    }

    public List<String> top(int n) {
        ArrayList<String> top = new ArrayList<String>();
        StringColumn copy = this.copy();
        copy.sortDescending();
        for (int i = 0; i < n; ++i) {
            top.add(copy.get(i));
        }
        return top;
    }

    public List<String> bottom(int n) {
        ArrayList<String> bottom = new ArrayList<String>();
        StringColumn copy = this.copy();
        copy.sortAscending();
        for (int i = 0; i < n; ++i) {
            bottom.add(copy.get(i));
        }
        return bottom;
    }

    private void addValue(String value) {
        int key = this.lookupTable.get(value);
        if (key <= 0) {
            key = this.nextIndex.getAndIncrement();
            this.lookupTable.put(key, value);
        }
        this.values.add(key);
    }

    public void initializeWith(IntArrayList list, StringColumn old) {
        IntListIterator intListIterator = list.iterator();
        while (intListIterator.hasNext()) {
            int key = (Integer)intListIterator.next();
            this.append(old.lookupTable.get(key));
        }
    }

    public boolean contains(String aString) {
        return this.firstIndexOf(aString) >= 0;
    }

    public IntArrayList getValues(IntArrayList indexes) {
        IntArrayList newList = new IntArrayList(indexes.size());
        IntListIterator intListIterator = indexes.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            newList.add(this.values.getInt(i));
        }
        return newList;
    }

    public StringColumn addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
        return this;
    }

    @Override
    public StringColumn appendCell(String object) {
        this.addValue(StringColumnType.DEFAULT_PARSER.parse(object));
        return this;
    }

    @Override
    public StringColumn appendCell(String object, StringParser parser) {
        this.addValue((String)parser.parse(object));
        return this;
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Selection isEqualTo(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int key = this.lookupTable.get(string);
        this.addValuesToSelection(results, key);
        return results;
    }

    public Selection isNotEqualTo(String string) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(0, this.size());
        selection.andNot(this.isEqualTo(string));
        return selection;
    }

    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Int2ObjectMap.Entry entry : this.lookupTable.keyToValueMap().int2ObjectEntrySet()) {
            BooleanColumn column = BooleanColumn.create((String)entry.getValue());
            results.add(column);
        }
        ObjectIterator objectIterator = this.values.iterator();
        while (objectIterator.hasNext()) {
            int next = (Integer)objectIterator.next();
            String category = this.lookupTable.get(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    private int getInt(int rowNumber) {
        return this.values.getInt(rowNumber);
    }

    @Override
    public StringColumn unique() {
        ArrayList<String> strings = new ArrayList<String>(this.lookupTable.categories());
        return StringColumn.create(this.name() + " Unique values", strings);
    }

    public IntArrayList data() {
        return this.values;
    }

    public NumberColumn asNumberColumn() {
        DoubleColumn numberColumn = DoubleColumn.create(this.name() + ": codes", this.size());
        IntArrayList data = this.data();
        for (int i = 0; i < this.size(); ++i) {
            numberColumn.append(data.getInt(i));
        }
        return numberColumn;
    }

    @Override
    public StringColumn where(Selection selection) {
        return (StringColumn)this.subset(selection);
    }

    @Override
    public StringColumn copy() {
        StringColumn newCol = StringColumn.create(this.name(), this.size());
        for (String string : this) {
            newCol.append(string);
        }
        return newCol;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        StringColumn source = (StringColumn)column;
        for (String string : source) {
            this.append(string);
        }
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!MISSING_VALUE.equals(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public StringColumn removeMissing() {
        StringColumn noMissing = this.emptyCopy();
        for (String v : this) {
            if (!StringColumn.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final IntListIterator valuesIt;
            {
                this.valuesIt = StringColumn.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIt.hasNext();
            }

            @Override
            public String next() {
                return StringColumn.this.lookupTable.get(this.valuesIt.nextInt());
            }
        };
    }

    public Set<String> asSet() {
        return this.lookupTable.categories();
    }

    private IntArrayList values() {
        return this.values;
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putInt(this.getInt(rowNumber)).array();
    }

    @Override
    public double getDouble(int i) {
        return this.getInt(i);
    }

    @Override
    public double[] asDoubleArray() {
        double[] doubles = new double[this.values.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.values.getInt(i);
        }
        return doubles;
    }

    private void addValuesToSelection(Selection results, int key) {
        if (key >= 0) {
            int i = 0;
            IntListIterator intListIterator = this.values.iterator();
            while (intListIterator.hasNext()) {
                int next = (Integer)intListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
    }

    public StringColumn append(String value) {
        this.appendCell(value);
        return this;
    }

    @Override
    public Selection isIn(String ... strings) {
        return this.selectIsIn(strings);
    }

    private Selection selectIsIn(String ... strings) {
        IntArrayList keys = new IntArrayList();
        for (String string : strings) {
            int key = this.lookupTable.get(string);
            if (key <= 0) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getInt(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.selectIsIn(strings));
        return results;
    }

    public Int2ObjectMap<String> keyToValueMap() {
        return new Int2ObjectOpenHashMap(this.lookupTable.keyToValue);
    }

    public int firstIndexOf(String value) {
        return this.values.indexOf(this.lookupTable.get(value));
    }

    public double countOccurrences(String value) {
        if (!this.lookupTable.contains(value)) {
            return 0.0;
        }
        int key = this.lookupTable.get(value);
        int count = 0;
        IntListIterator intListIterator = this.values.iterator();
        while (intListIterator.hasNext()) {
            int k = (Integer)intListIterator.next();
            if (k != key) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new String[this.values().size()];
        for (int i = 0; i < this.values().size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    static class DictionaryMap {
        private final Int2ObjectMap<String> keyToValue = new Int2ObjectOpenHashMap();
        private final Object2IntMap<String> valueToKey = new Object2IntOpenHashMap();

        DictionaryMap() {
            this.valueToKey.defaultReturnValue(-1);
        }

        DictionaryMap(DictionaryMap original) {
            for (Int2ObjectMap.Entry entry : original.keyToValue.int2ObjectEntrySet()) {
                this.keyToValue.put(entry.getIntKey(), (Object)((String)entry.getValue()));
                this.valueToKey.put((Object)((String)entry.getValue()), entry.getIntKey());
            }
            this.valueToKey.defaultReturnValue(-1);
        }

        void put(int key, String value) {
            this.keyToValue.put(key, (Object)value);
            this.valueToKey.put((Object)value, key);
        }

        String get(int key) {
            return (String)this.keyToValue.get(key);
        }

        int get(String value) {
            return this.valueToKey.getInt((Object)value);
        }

        void remove(int key) {
            String value = (String)this.keyToValue.remove(key);
            this.valueToKey.removeInt((Object)value);
        }

        void remove(String value) {
            int key = this.valueToKey.removeInt((Object)value);
            this.keyToValue.remove(key);
        }

        void clear() {
            this.keyToValue.clear();
            this.valueToKey.clear();
        }

        boolean contains(String stringValue) {
            return this.valueToKey.containsKey((Object)stringValue);
        }

        int size() {
            return this.categories().size();
        }

        Set<String> categories() {
            return this.valueToKey.keySet();
        }

        @Deprecated
        String[] categoryArray() {
            return (String[])this.keyToValue.values().toArray((Object[])new String[this.size()]);
        }

        IntCollection values() {
            return this.valueToKey.values();
        }

        Int2ObjectMap<String> keyToValueMap() {
            return this.keyToValue;
        }

        Object2IntMap<String> valueToKeyMap() {
            return this.valueToKey;
        }
    }
}

