/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

@Immutable
public final class TypeUtils {
    public static final List<String> TRUE_STRINGS = Arrays.asList("T", "t", "Y", "y", "TRUE", "true", "True", "1");
    public static final List<String> TRUE_STRINGS_FOR_DETECTION = Arrays.asList("T", "t", "Y", "y", "TRUE", "true", "True");
    public static final List<String> FALSE_STRINGS = Arrays.asList("F", "f", "N", "n", "FALSE", "false", "False", "0");
    public static final List<String> FALSE_STRINGS_FOR_DETECTION = Arrays.asList("F", "f", "N", "n", "FALSE", "false", "False");
    private static final DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter dtf3 = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private static final DateTimeFormatter dtf4 = DateTimeFormatter.ofPattern("MM.dd.yyyy");
    private static final DateTimeFormatter dtf5 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dtf6 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter dtf7 = DateTimeFormatter.ofPattern("dd/MMM/yyyy");
    private static final DateTimeFormatter dtf8 = DateTimeFormatter.ofPattern("dd-MMM-yyyy");
    private static final DateTimeFormatter dtf9 = DateTimeFormatter.ofPattern("M/d/yyyy");
    private static final DateTimeFormatter dtf10 = DateTimeFormatter.ofPattern("M/d/yy");
    private static final DateTimeFormatter dtf11 = DateTimeFormatter.ofPattern("MMM/dd/yyyy");
    private static final DateTimeFormatter dtf12 = DateTimeFormatter.ofPattern("MMM-dd-yyyy");
    private static final DateTimeFormatter dtf13 = DateTimeFormatter.ofPattern("MMM/dd/yy");
    private static final DateTimeFormatter dtf14 = DateTimeFormatter.ofPattern("MMM-dd-yy");
    private static final DateTimeFormatter dtf15 = DateTimeFormatter.ofPattern("MMM/dd/yyyy");
    private static final DateTimeFormatter dtf16 = DateTimeFormatter.ofPattern("MMM/d/yyyy");
    private static final DateTimeFormatter dtf17 = DateTimeFormatter.ofPattern("MMM-dd-yy");
    private static final DateTimeFormatter dtf18 = DateTimeFormatter.ofPattern("MMM dd, yyyy");
    private static final DateTimeFormatter dtf19 = DateTimeFormatter.ofPattern("MMM d, yyyy");
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendOptional(dtf1).appendOptional(dtf2).appendOptional(dtf3).appendOptional(dtf4).appendOptional(dtf5).appendOptional(dtf6).appendOptional(dtf7).appendOptional(dtf8).appendOptional(dtf9).appendOptional(dtf10).appendOptional(dtf11).appendOptional(dtf12).appendOptional(dtf13).appendOptional(dtf14).appendOptional(dtf15).appendOptional(dtf16).appendOptional(dtf17).appendOptional(dtf18).appendOptional(dtf19).toFormatter();
    private static final DateTimeFormatter dtTimef0 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dtTimef2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");
    private static final DateTimeFormatter dtTimef4 = DateTimeFormatter.ofPattern("dd-MMM-yyyy HH:mm");
    private static final DateTimeFormatter dtTimef5 = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter dtTimef6;
    private static final DateTimeFormatter dtTimef7;
    private static final DateTimeFormatter dtTimef8;
    public static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final DateTimeFormatter timef1;
    private static final DateTimeFormatter timef2;
    private static final DateTimeFormatter timef3;
    private static final DateTimeFormatter timef4;
    private static final DateTimeFormatter timef5;
    private static final DateTimeFormatter timef6;
    public static final DateTimeFormatter TIME_DETECTION_FORMATTER;
    private static final DateTimeFormatter timef7;
    public static final DateTimeFormatter TIME_FORMATTER;
    private static final String missingInd1 = "NaN";
    private static final String missingInd2 = "*";
    private static final String missingInd3 = "NA";
    private static final String missingInd4 = "null";
    public static final ImmutableList<String> MISSING_INDICATORS;
    private static ImmutableList<DateTimeFormatter> dateFormatters;
    private static ImmutableList<DateTimeFormatter> dateTimeFormatters;
    private static ImmutableList<DateTimeFormatter> timeFormatters;

    private TypeUtils() {
    }

    public static Column newColumn(@Nonnull String name, @Nonnull ColumnType type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"There must be a valid name for a new column");
        Preconditions.checkArgument((type != ColumnType.SKIP ? 1 : 0) != 0, (Object)"SKIP-ped columns should be handled outside of this method.");
        switch (type) {
            case LOCAL_DATE: {
                return DateColumn.create(name);
            }
            case LOCAL_TIME: {
                return TimeColumn.create(name);
            }
            case LOCAL_DATE_TIME: {
                return DateTimeColumn.create(name);
            }
            case NUMBER: {
                return DoubleColumn.create(name);
            }
            case BOOLEAN: {
                return BooleanColumn.create(name);
            }
            case STRING: {
                return StringColumn.create(name);
            }
        }
        throw new IllegalArgumentException("Unknown ColumnType: " + (Object)((Object)type));
    }

    public static DateTimeFormatter getDateFormatter(String dateValue) {
        for (DateTimeFormatter formatter : dateFormatters) {
            try {
                formatter.parse(dateValue);
                return formatter;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return DATE_FORMATTER;
    }

    public static DateTimeFormatter getDateTimeFormatter(String dateTimeValue) {
        for (DateTimeFormatter formatter : dateTimeFormatters) {
            if (!TypeUtils.canParse(formatter, dateTimeValue)) continue;
            return formatter;
        }
        if (TypeUtils.canParse(DATE_FORMATTER, dateTimeValue)) {
            return DATE_FORMATTER;
        }
        if (TypeUtils.canParse(DATE_TIME_FORMATTER, dateTimeValue)) {
            return DATE_TIME_FORMATTER;
        }
        throw new IllegalArgumentException("Could not find datetime parser for " + dateTimeValue);
    }

    public static boolean canParse(DateTimeFormatter formatter, String dateTimeValue) {
        try {
            formatter.parse(dateTimeValue);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static DateTimeFormatter getTimeFormatter(String timeValue) {
        for (DateTimeFormatter formatter : timeFormatters) {
            try {
                formatter.parse(timeValue);
                return formatter;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return DATE_FORMATTER;
    }

    static {
        dtTimef7 = DateTimeFormatter.ofPattern("M/d/yy H:mm");
        dtTimef8 = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a");
        dtTimef6 = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendLiteral('.').appendPattern("SSS").toFormatter();
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(dtTimef7).appendOptional(dtTimef8).appendOptional(dtTimef2).appendOptional(dtTimef4).appendOptional(dtTimef0).appendOptional(dtTimef5).appendOptional(dtTimef6).toFormatter();
        timef1 = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        timef2 = DateTimeFormatter.ofPattern("hh:mm:ss a");
        timef3 = DateTimeFormatter.ofPattern("h:mm:ss a");
        timef4 = DateTimeFormatter.ISO_LOCAL_TIME;
        timef5 = DateTimeFormatter.ofPattern("hh:mm a");
        timef6 = DateTimeFormatter.ofPattern("h:mm a");
        TIME_DETECTION_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).toFormatter();
        timef7 = DateTimeFormatter.ofPattern("HHmm");
        TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).appendOptional(timef7).toFormatter();
        MISSING_INDICATORS = ImmutableList.of((Object)missingInd1, (Object)missingInd2, (Object)missingInd3, (Object)missingInd4);
        dateFormatters = ImmutableList.of((Object)dtf1, (Object)dtf2, (Object)dtf3, (Object)dtf4, (Object)dtf5, (Object)dtf6, (Object)dtf7, (Object)dtf8, (Object)dtf9, (Object)dtf10, (Object)dtf11, (Object)dtf12, (Object[])new DateTimeFormatter[]{dtf13, dtf14, dtf15, dtf16, dtf17, dtf18, dtf19});
        dateTimeFormatters = ImmutableList.of((Object)dtTimef0, (Object)dtTimef2, (Object)dtTimef4, (Object)dtTimef5, (Object)dtTimef6, (Object)dtTimef7, (Object)dtTimef8);
        timeFormatters = ImmutableList.of((Object)timef1, (Object)timef2, (Object)timef3, (Object)timef4, (Object)timef5, (Object)timef6);
    }
}

