/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.dates.PackedLocalDate;

public class PackedDate {
    private int index = 0;
    private final DateColumn dateColumn;

    public PackedDate(DateColumn column) {
        this.dateColumn = column;
    }

    public PackedDate next() {
        ++this.index;
        return this;
    }

    public PackedDate get(int rowNumber) {
        this.index = rowNumber;
        return this;
    }

    public int getPackedValue() {
        return this.dateColumn.getIntInternal(this.index);
    }

    public LocalDate asLocalDate() {
        return PackedLocalDate.asLocalDate(this.dateColumn.getIntInternal(this.index));
    }

    public byte getMonthValue() {
        return PackedLocalDate.getMonthValue(this.dateColumn.getIntInternal(this.index));
    }

    public String toDateString() {
        return PackedLocalDate.toDateString(this.dateColumn.getIntInternal(this.index));
    }

    public String toString() {
        return this.toDateString();
    }

    public int getDayOfYear() {
        return PackedLocalDate.getDayOfYear(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isLeapYear() {
        return PackedLocalDate.isLeapYear(this.dateColumn.getIntInternal(this.index));
    }

    public Month getMonth() {
        return PackedLocalDate.getMonth(this.dateColumn.getIntInternal(this.index));
    }

    public int lengthOfMonth() {
        return PackedLocalDate.lengthOfMonth(this.dateColumn.getIntInternal(this.index));
    }

    public long toEpochDay() {
        return PackedLocalDate.toEpochDay(this.dateColumn.getIntInternal(this.index));
    }

    public DayOfWeek getDayOfWeek() {
        return PackedLocalDate.getDayOfWeek(this.dateColumn.getIntInternal(this.index));
    }

    public int getQuarter() {
        return PackedLocalDate.getQuarter(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isinQ1() {
        return PackedLocalDate.isInQ1(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isinQ2() {
        return PackedLocalDate.isInQ2(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInQ3() {
        return PackedLocalDate.isInQ3(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInQ4() {
        return PackedLocalDate.isInQ4(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isAfter(LocalDate date) {
        return PackedLocalDate.isAfter(this.dateColumn.getIntInternal(this.index), PackedLocalDate.pack(date));
    }

    public boolean isAfter(int packedDate) {
        return PackedLocalDate.isAfter(this.dateColumn.getIntInternal(this.index), packedDate);
    }

    public boolean isBefore(LocalDate date) {
        return PackedLocalDate.isBefore(this.dateColumn.getIntInternal(this.index), PackedLocalDate.pack(date));
    }

    public boolean isBefore(int packedDate) {
        return PackedLocalDate.isBefore(this.dateColumn.getIntInternal(this.index), packedDate);
    }

    public boolean isOnOrAfter(LocalDate date) {
        return PackedLocalDate.isOnOrAfter(this.dateColumn.getIntInternal(this.index), PackedLocalDate.pack(date));
    }

    public boolean isOnOrAfter(int packedDate) {
        return PackedLocalDate.isOnOrAfter(this.dateColumn.getIntInternal(this.index), packedDate);
    }

    public boolean isOnOrBefore(LocalDate date) {
        return PackedLocalDate.isOnOrBefore(this.dateColumn.getIntInternal(this.index), PackedLocalDate.pack(date));
    }

    public boolean isOnOrBefore(int packedDate) {
        return PackedLocalDate.isOnOrBefore(this.dateColumn.getIntInternal(this.index), packedDate);
    }

    public boolean isSunday() {
        return PackedLocalDate.isSunday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isMonday() {
        return PackedLocalDate.isMonday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isTuesday() {
        return PackedLocalDate.isTuesday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isWednesday() {
        return PackedLocalDate.isWednesday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isThursday() {
        return PackedLocalDate.isThursday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isFriday() {
        return PackedLocalDate.isFriday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isSaturday() {
        return PackedLocalDate.isSaturday(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isFirstDayOfMonth() {
        return PackedLocalDate.isFirstDayOfMonth(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isLastDayOfMonth() {
        return PackedLocalDate.isLastDayOfMonth(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInYear(int year) {
        return PackedLocalDate.isInYear(this.dateColumn.getIntInternal(this.index), year);
    }

    public int lengthOfYear() {
        return PackedLocalDate.lengthOfYear(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInJanuary() {
        return PackedLocalDate.isInJanuary(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInFebruary() {
        return PackedLocalDate.isInFebruary(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInMarch() {
        return PackedLocalDate.isInMarch(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInApril() {
        return PackedLocalDate.isInApril(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInMay() {
        return PackedLocalDate.isInMay(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInJune() {
        return PackedLocalDate.isInJune(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInJuly() {
        return PackedLocalDate.isInJuly(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInAugust() {
        return PackedLocalDate.isInAugust(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInSeptember() {
        return PackedLocalDate.isInSeptember(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInOctober() {
        return PackedLocalDate.isInOctober(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInNovember() {
        return PackedLocalDate.isInNovember(this.dateColumn.getIntInternal(this.index));
    }

    public boolean isInDecember() {
        return PackedLocalDate.isInDecember(this.dateColumn.getIntInternal(this.index));
    }

    public int getYear() {
        return PackedLocalDate.getYear(this.dateColumn.getIntInternal(this.index));
    }
}

