/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.datetimes.DateTimeColumnFormatter;
import tech.tablesaw.columns.datetimes.DateTimeFillers;
import tech.tablesaw.columns.datetimes.DateTimeFilters;
import tech.tablesaw.columns.datetimes.DateTimeMapFunctions;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.comparators.DescendingLongComparator;

public class DateTimeColumn
extends AbstractColumn
implements DateTimeMapFunctions,
DateTimeFilters,
DateTimeFillers<DateTimeColumn>,
Iterable<LocalDateTime> {
    public static final long MISSING_VALUE = (Long)ColumnType.LOCAL_DATE_TIME.getMissingValue();
    private final LongComparator reverseLongComparator = DescendingLongComparator.instance();
    private LongArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        long f1 = this.getPackedDateTime(r1);
        long f2 = this.getPackedDateTime(r2);
        return Long.compare(f1, f2);
    };
    private DateTimeFormatter selectedFormatter;
    private DateTimeColumnFormatter printFormatter = new DateTimeColumnFormatter();
    private Locale locale;

    public void setFormatter(DateTimeFormatter formatter) {
        this.selectedFormatter = formatter;
    }

    public static boolean valueIsMissing(long value) {
        return MISSING_VALUE == value;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return DateTimeColumn.valueIsMissing(this.getLongInternal(rowNumber));
    }

    public static DateTimeColumn create(String name) {
        return DateTimeColumn.create(name, 128);
    }

    public static DateTimeColumn create(String name, int initialSize) {
        return DateTimeColumn.create(name, initialSize, Locale.getDefault());
    }

    public static DateTimeColumn create(String name, int initialSize, Locale locale) {
        return new DateTimeColumn(name, new LongArrayList(initialSize), locale);
    }

    public static DateTimeColumn create(String name, List<LocalDateTime> data) {
        DateTimeColumn column = new DateTimeColumn(name, new LongArrayList(data.size()), Locale.getDefault());
        for (LocalDateTime date : data) {
            column.append(date);
        }
        return column;
    }

    public static DateTimeColumn create(String name, LocalDateTime[] data) {
        DateTimeColumn column = new DateTimeColumn(name, new LongArrayList(data.length), Locale.getDefault());
        for (LocalDateTime date : data) {
            column.append(date);
        }
        return column;
    }

    private DateTimeColumn(String name, LongArrayList data, Locale locale) {
        super(ColumnType.LOCAL_DATE_TIME, name);
        this.data = data;
        this.locale = locale;
    }

    @Override
    public DateTimeColumn removeMissing() {
        DateTimeColumn noMissing = this.emptyCopy();
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            long i = iterator.nextLong();
            if (DateTimeColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    public boolean contains(LocalDateTime dateTime) {
        long dt = PackedLocalDateTime.pack(dateTime);
        return this.data().contains(dt);
    }

    @Override
    public DateTimeColumn where(Selection selection) {
        return (DateTimeColumn)this.subset(selection);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter, String missingValueString) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        Preconditions.checkNotNull((Object)missingValueString);
        this.printFormatter = new DateTimeColumnFormatter(dateTimeFormatter, missingValueString);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        this.printFormatter = new DateTimeColumnFormatter(dateTimeFormatter);
    }

    public void setPrintFormatter(DateTimeColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    @Override
    public DateTimeColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        long[] dest = new long[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = MISSING_VALUE;
        }
        System.arraycopy(this.data.toLongArray(), srcPos, dest, destPos, length);
        DateTimeColumn copy = this.emptyCopy(this.size());
        copy.data = new LongArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public DateTimeColumn appendCell(String stringValue) {
        if (stringValue == null) {
            this.appendInternal(MISSING_VALUE);
        } else {
            long dateTime = this.convert(stringValue);
            this.appendInternal(dateTime);
        }
        return this;
    }

    public DateTimeColumn append(LocalDateTime dateTime) {
        if (dateTime != null) {
            long dt = PackedLocalDateTime.pack(dateTime);
            this.appendInternal(dt);
        } else {
            this.appendInternal(MISSING_VALUE);
        }
        return this;
    }

    public long convert(String value) {
        if (Strings.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains((Object)value) || value.equals("-1")) {
            return MISSING_VALUE;
        }
        value = Strings.padStart((String)value, (int)4, (char)'0');
        LocalDateTime dateTime = this.parseDateTime(value);
        return PackedLocalDateTime.pack(dateTime);
    }

    private LocalDateTime parseDateTime(String value) {
        if (this.selectedFormatter == null) {
            this.setFormatter(TypeUtils.getDateTimeFormatter(value));
        }
        if (!TypeUtils.canParse(this.selectedFormatter, value)) {
            this.setFormatter(TypeUtils.getDateTimeFormatter(value));
        }
        return LocalDateTime.parse(value, this.selectedFormatter);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_DATE_TIME;
    }

    public DateTimeColumn appendInternal(long dateTime) {
        this.data.add(dateTime);
        return this;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedDateTime(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedLocalDateTime.toString(this.getPackedDateTime(row));
    }

    @Override
    public DateTimeColumn emptyCopy() {
        return this.emptyCopy(128);
    }

    @Override
    public DateTimeColumn emptyCopy(int rowSize) {
        DateTimeColumn column = DateTimeColumn.create(this.name(), rowSize, this.locale);
        column.setFormatter(this.selectedFormatter);
        column.setPrintFormatter(this.printFormatter);
        return column;
    }

    @Override
    public DateTimeColumn copy() {
        DateTimeColumn column = this.emptyCopy(this.data.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        LongArrays.parallelQuickSort((long[])this.data.elements(), (LongComparator)this.reverseLongComparator);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(measure);
        table.addColumns(value);
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countUnique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        return ints.size();
    }

    @Override
    public DateTimeColumn unique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        DateTimeColumn column = this.emptyCopy(ints.size());
        column.setName(this.name() + " Unique values");
        column.data = LongArrayList.wrap((long[])ints.toLongArray());
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    long getPackedDateTime(int index) {
        return this.getLongInternal(index);
    }

    @Override
    public LocalDateTime get(int index) {
        return PackedLocalDateTime.asLocalDateTime(this.getPackedDateTime(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public DateTimeColumn set(Selection rowSelection, LocalDateTime newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getPackedDateTime(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    public long[] asEpochSecondArray() {
        return this.asEpochSecondArray(ZoneOffset.UTC);
    }

    public long[] asEpochSecondArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i)).toEpochSecond(offset);
        }
        return output;
    }

    public long[] asEpochMillisArray() {
        return this.asEpochMillisArray(ZoneOffset.UTC);
    }

    public long[] asEpochMillisArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i)).toInstant(offset).toEpochMilli();
        }
        return output;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DateTimeColumn doubleColumn = (DateTimeColumn)column;
        for (int i = 0; i < doubleColumn.size(); ++i) {
            this.append(doubleColumn.get(i));
        }
    }

    public LocalDateTime max() {
        if (this.isEmpty()) {
            return null;
        }
        long max = this.getPackedDateTime(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (MISSING_VALUE == aData) continue;
            max = max > aData ? max : aData;
        }
        if (MISSING_VALUE == max) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(max);
    }

    @Override
    public DateTimeColumn appendMissing() {
        this.appendInternal(MISSING_VALUE);
        return this;
    }

    @Override
    public LocalDateTime min() {
        if (this.isEmpty()) {
            return null;
        }
        long min = this.getPackedDateTime(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (MISSING_VALUE == aData) continue;
            min = min < aData ? min : aData;
        }
        if (Integer.MIN_VALUE == min) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(min);
    }

    public DateTimeColumn set(int index, long value) {
        this.data.set(index, value);
        return this;
    }

    public DateTimeColumn set(int index, LocalDateTime value) {
        this.data.set(index, PackedLocalDateTime.pack(value));
        return this;
    }

    public List<LocalDateTime> top(int n) {
        ArrayList<LocalDateTime> top = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)DescendingLongComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return top;
    }

    public List<LocalDateTime> bottom(int n) {
        ArrayList<LocalDateTime> bottom = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return bottom;
    }

    public LongIterator longIterator() {
        return this.data.iterator();
    }

    public Set<LocalDateTime> asSet() {
        HashSet<LocalDateTime> times = new HashSet<LocalDateTime>();
        DateTimeColumn unique = this.unique();
        for (LocalDateTime localDateTime : unique) {
            times.add(localDateTime);
        }
        return times;
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putLong(this.getPackedDateTime(rowNumber)).array();
    }

    @Override
    public double getDouble(int i) {
        return this.getPackedDateTime(i);
    }

    @Override
    public double[] asDoubleArray() {
        double[] doubles = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getLong(i);
        }
        return doubles;
    }

    @Override
    public Iterator<LocalDateTime> iterator() {
        return new Iterator<LocalDateTime>(){
            final LongIterator longIterator;
            {
                this.longIterator = DateTimeColumn.this.longIterator();
            }

            @Override
            public boolean hasNext() {
                return this.longIterator.hasNext();
            }

            @Override
            public LocalDateTime next() {
                return PackedLocalDateTime.asLocalDateTime(this.longIterator.nextLong());
            }
        };
    }

    private DateTimeColumn fillWith(int count, Iterator<LocalDateTime> iterator, Consumer<LocalDateTime> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Iterator<LocalDateTime> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    private DateTimeColumn fillWith(int count, Iterable<LocalDateTime> iterable, Consumer<LocalDateTime> acceptor) {
        Iterator<LocalDateTime> iterator = null;
        for (int r = 0; r < count && (iterator != null && iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Iterable<LocalDateTime> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    private DateTimeColumn fillWith(int count, Supplier<LocalDateTime> supplier, Consumer<LocalDateTime> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Supplier<LocalDateTime> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new LocalDateTime[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }
}

