/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.booleans.BooleanColumnUtils;
import tech.tablesaw.columns.booleans.BooleanFillers;
import tech.tablesaw.columns.booleans.BooleanFormatter;
import tech.tablesaw.columns.booleans.BooleanMapUtils;
import tech.tablesaw.filtering.predicates.BytePredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class BooleanColumn
extends AbstractColumn
implements BooleanMapUtils,
CategoricalColumn,
BooleanFillers<BooleanColumn>,
Iterable<Boolean> {
    public static final byte MISSING_VALUE = (Byte)ColumnType.BOOLEAN.getMissingValue();
    private static final byte BYTE_TRUE = 1;
    private static final byte BYTE_FALSE = 0;
    private final ByteComparator descendingByteComparator = (o1, o2) -> Byte.compare(o2, o1);
    private ByteArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        boolean f1 = this.get(r1);
        boolean f2 = this.get(r2);
        return Boolean.compare(f1, f2);
    };
    private BooleanFormatter formatter = new BooleanFormatter("true", "false", "");

    private BooleanColumn(String name, ByteArrayList values) {
        super(ColumnType.BOOLEAN, name);
        this.data = values;
    }

    public static boolean valueIsMissing(byte b) {
        return b == MISSING_VALUE;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return BooleanColumn.valueIsMissing(this.getByte(rowNumber));
    }

    public static BooleanColumn create(String name, Selection hits, int columnSize) {
        BooleanColumn column = BooleanColumn.create(name, columnSize);
        Preconditions.checkArgument((hits.size() <= columnSize ? 1 : 0) != 0, (Object)"Cannot have more true values than total values in a boolean column");
        for (int i = 0; i < columnSize; ++i) {
            column.append((byte)0);
        }
        IntIterator intIterator = hits.iterator();
        while (intIterator.hasNext()) {
            int hit = (Integer)intIterator.next();
            column.set(hit, true);
        }
        return column;
    }

    public static BooleanColumn create(String name) {
        return new BooleanColumn(name, new ByteArrayList(128));
    }

    public static BooleanColumn create(String name, int initialSize) {
        return new BooleanColumn(name, new ByteArrayList(initialSize));
    }

    public static BooleanColumn create(String name, boolean[] values) {
        BooleanColumn column = BooleanColumn.create(name, values.length);
        for (boolean b : values) {
            column.append(b);
        }
        return column;
    }

    public static BooleanColumn create(String name, List<Boolean> values) {
        BooleanColumn column = BooleanColumn.create(name, values.size());
        for (Boolean b : values) {
            column.append(b);
        }
        return column;
    }

    public static BooleanColumn create(String name, Boolean[] objects) {
        BooleanColumn column = BooleanColumn.create(name, objects.length);
        for (Boolean b : objects) {
            column.append(b);
        }
        return column;
    }

    public void setPrintFormatter(BooleanFormatter formatter) {
        this.formatter = formatter;
    }

    public BooleanFormatter getPrintFormatter() {
        return this.formatter;
    }

    public static byte convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        if (TypeUtils.TRUE_STRINGS.contains(stringValue)) {
            return 1;
        }
        if (TypeUtils.FALSE_STRINGS.contains(stringValue)) {
            return 0;
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + stringValue + " to Boolean");
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        Byte2IntOpenHashMap counts = new Byte2IntOpenHashMap(3);
        counts.put((byte)0, 0);
        counts.put((byte)1, 0);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            counts.put(next, counts.get(next) + 1);
        }
        Table table = Table.create(this.name());
        BooleanColumn booleanColumn = BooleanColumn.create("Value");
        DoubleColumn countColumn = DoubleColumn.create("Count");
        table.addColumns(booleanColumn);
        table.addColumns(countColumn);
        for (Map.Entry entry : counts.byte2IntEntrySet()) {
            booleanColumn.append((Byte)entry.getKey());
            countColumn.append(((Integer)entry.getValue()).intValue());
        }
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!BooleanColumn.valueIsMissing(this.getByte(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        return count.size();
    }

    @Override
    public BooleanColumn unique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        ByteArrayList list = new ByteArrayList((ByteCollection)count);
        return new BooleanColumn(this.name() + " Unique values", list);
    }

    @Override
    public ColumnType type() {
        return ColumnType.BOOLEAN;
    }

    public BooleanColumn append(boolean b) {
        if (b) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
        return this;
    }

    public BooleanColumn append(Boolean b) {
        if (b == null) {
            this.data.add(MISSING_VALUE);
        } else if (b.booleanValue()) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
        return this;
    }

    public BooleanColumn append(byte b) {
        this.data.add(b);
        return this;
    }

    @Override
    public BooleanColumn appendMissing() {
        this.append(MISSING_VALUE);
        return this;
    }

    @Override
    public String getString(int row) {
        return this.formatter.format(this.get(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return String.valueOf(this.get(row));
    }

    @Override
    public BooleanColumn emptyCopy() {
        return BooleanColumn.create(this.name());
    }

    @Override
    public BooleanColumn emptyCopy(int rowSize) {
        return BooleanColumn.create(this.name(), rowSize);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public BooleanColumn copy() {
        return new BooleanColumn(this.name(), this.data.clone());
    }

    @Override
    public void sortAscending() {
        ByteArrays.mergeSort((byte[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        ByteArrays.mergeSort((byte[])this.data.elements(), (ByteComparator)this.descendingByteComparator);
    }

    @Override
    public BooleanColumn appendCell(String object) {
        this.append(BooleanColumn.convert(object));
        return this;
    }

    public Boolean get(int i) {
        byte b = this.data.getByte(i);
        if (b == 1) {
            return Boolean.TRUE;
        }
        if (b == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    public byte getByte(int i) {
        return this.data.getByte(i);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int countTrue() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 1) continue;
            ++count;
        }
        return count;
    }

    public int countFalse() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 0) continue;
            ++count;
        }
        return count;
    }

    public double proportionTrue() {
        double n = this.size() - this.countMissing();
        double trueCount = this.countTrue();
        return trueCount / n;
    }

    public double proportionFalse() {
        return 1.0 - this.proportionTrue();
    }

    public boolean any() {
        return this.countTrue() > 0;
    }

    public boolean all() {
        return this.countTrue() == this.size();
    }

    public boolean none() {
        return this.countTrue() == 0;
    }

    public Selection isFalse() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isTrue() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 1) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isEqualTo(BooleanColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteIterator booleanIterator = other.byteIterator();
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == booleanIterator.nextByte()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public ByteArrayList data() {
        return this.data;
    }

    public BooleanColumn set(int i, boolean b) {
        if (b) {
            this.data.set(i, (byte)1);
        } else {
            this.data.set(i, (byte)0);
        }
        return this;
    }

    @Override
    public BooleanColumn lead(int n) {
        BooleanColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    @Override
    public BooleanColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        byte[] dest = new byte[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = MISSING_VALUE;
        }
        System.arraycopy(this.data.toByteArray(), srcPos, dest, destPos, length);
        BooleanColumn copy = this.emptyCopy(this.size());
        copy.data = new ByteArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    public BooleanColumn set(Selection rowSelection, boolean newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public double getDouble(int row) {
        return this.getByte(row);
    }

    @Override
    public double[] asDoubleArray() {
        double[] doubles = new double[this.data.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getByte(i);
        }
        return doubles;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        BooleanColumn booleanColumn = (BooleanColumn)column;
        for (int i = 0; i < booleanColumn.size(); ++i) {
            this.append(booleanColumn.get(i));
        }
    }

    @Override
    public Selection asSelection() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            byte value = this.getByte(i);
            if (value != 1) continue;
            selection.add(i);
        }
        return selection;
    }

    @Override
    public Selection isMissing() {
        return this.eval(BooleanColumnUtils.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.eval(BooleanColumnUtils.isNotMissing);
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new BooleanColumnIterator(this.byteIterator());
    }

    public ByteIterator byteIterator() {
        return this.data.iterator();
    }

    public BooleanSet asSet() {
        BooleanOpenHashSet set = new BooleanOpenHashSet(3);
        BooleanColumn unique = this.unique();
        for (int i = 0; i < unique.size(); ++i) {
            set.add(unique.get(i).booleanValue());
        }
        return set;
    }

    public boolean contains(boolean aBoolean) {
        if (aBoolean) {
            return this.data().contains((byte)1);
        }
        return this.data().contains((byte)0);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int row) {
        byte[] result = new byte[this.byteSize()];
        result[0] = this.get(row) != false ? (byte)1 : 0;
        return result;
    }

    @Override
    public BooleanColumn where(Selection selection) {
        return (BooleanColumn)this.subset(selection);
    }

    @Override
    public BooleanColumn removeMissing() {
        BooleanColumn noMissing = this.emptyCopy();
        ByteListIterator iterator = this.byteListIterator();
        while (iterator.hasNext()) {
            byte b = iterator.nextByte();
            if (BooleanColumn.valueIsMissing(b)) continue;
            noMissing.append(b);
        }
        return noMissing;
    }

    public Selection eval(BytePredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            byte next = this.data.getByte(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection eval(Predicate<Boolean> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection eval(BiPredicate<Boolean, Boolean> predicate, Boolean valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            if (!predicate.test(this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    private ByteListIterator byteListIterator() {
        return this.data.iterator();
    }

    @Override
    public int[] asIntArray() {
        int[] output = new int[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getByte(i);
        }
        return output;
    }

    public NumberColumn asNumberColumn() {
        DoubleColumn numberColumn = DoubleColumn.create(this.name() + ": ints", this.size());
        ByteArrayList data = this.data();
        for (int i = 0; i < this.size(); ++i) {
            numberColumn.append(data.getByte(i));
        }
        return numberColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanColumn that = (BooleanColumn)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public BooleanColumn fillWith(BooleanIterator iterator) {
        for (int r = 0; r < this.size() && iterator.hasNext(); ++r) {
            this.set(r, iterator.nextBoolean());
        }
        return this;
    }

    @Override
    public BooleanColumn fillWith(BooleanIterable iterable) {
        BooleanIterator iterator = null;
        for (int r = 0; r < this.size() && (iterator != null && iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            this.set(r, iterator.nextBoolean());
        }
        return this;
    }

    @Override
    public BooleanColumn fillWith(Supplier<Boolean> supplier) {
        for (int r = 0; r < this.size(); ++r) {
            try {
                this.set(r, (boolean)supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new Boolean[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    private static class BooleanColumnIterator
    implements Iterator<Boolean> {
        final ByteIterator iterator;

        BooleanColumnIterator(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Boolean next() {
            byte b = this.iterator.nextByte();
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            return null;
        }
    }
}

