/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;

@Immutable
public class DateTimeColumnFormatter {
    private final DateTimeFormatter format;
    private String missingValueString = "";

    public DateTimeColumnFormatter() {
        this.format = null;
    }

    public DateTimeColumnFormatter(DateTimeFormatter format) {
        this.format = format;
    }

    public DateTimeColumnFormatter(DateTimeFormatter format, String missingValueString) {
        this.format = format;
        this.missingValueString = missingValueString;
    }

    public String format(long value) {
        if (value == (long)TimeColumn.MISSING_VALUE) {
            return this.missingValueString;
        }
        if (this.format == null) {
            return PackedLocalDateTime.toString(value);
        }
        LocalDateTime time = PackedLocalDateTime.asLocalDateTime(value);
        return this.format.format(time);
    }

    public String toString() {
        return "DateTimeColumnFormatter{format=" + this.format + ", missingValueString='" + this.missingValueString + '\'' + '}';
    }
}

