/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.dates.PackedLocalDate;

@Immutable
public class DateColumnFormatter {
    private DateTimeFormatter format;
    private String missingString = "";

    public DateColumnFormatter() {
        this.format = null;
    }

    public DateColumnFormatter(DateTimeFormatter format) {
        this.format = format;
    }

    public DateColumnFormatter(DateTimeFormatter format, String missingString) {
        this.format = format;
        this.missingString = missingString;
    }

    public String format(int value) {
        if (value == DateColumn.MISSING_VALUE) {
            return this.missingString;
        }
        if (this.format == null) {
            return PackedLocalDate.toDateString(value);
        }
        LocalDate date = PackedLocalDate.asLocalDate(value);
        return this.format.format(date);
    }

    public String toString() {
        return "DateColumnFormatter{format=" + this.format + ", missingString='" + this.missingString + '\'' + '}';
    }
}

