/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import com.google.common.collect.TreeBasedTable;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public final class CrossTab {
    private static final String LABEL_COLUMN_NAME = "[labels]";

    public static Table counts(Table table, CategoricalColumn column1, CategoricalColumn column2) {
        Table t = Table.create("Crosstab Counts: " + column1.name() + " x " + column2.name());
        t.addColumns(column1.type().create(LABEL_COLUMN_NAME));
        Table temp = table.sortOn(column1.name(), column2.name());
        int colIndex1 = table.columnIndex(column1.name());
        int colIndex2 = table.columnIndex(column2.name());
        TreeBasedTable gTable = TreeBasedTable.create();
        for (int row = 0; row < table.rowCount(); ++row) {
            String b;
            String a = temp.column(colIndex1).getString(row);
            Integer cellValue = (Integer)gTable.get((Object)a, (Object)(b = temp.column(colIndex2).getString(row)));
            Integer value = cellValue != null ? Integer.valueOf(cellValue + 1) : Integer.valueOf(1);
            gTable.put((Object)a, (Object)b, (Object)value);
        }
        for (Object colName : gTable.columnKeySet()) {
            t.addColumns(DoubleColumn.create((String)colName));
        }
        t.addColumns(DoubleColumn.create("total"));
        int[] columnTotals = new int[t.columnCount()];
        for (String rowKey : gTable.rowKeySet()) {
            t.column(0).appendCell(rowKey);
            int rowSum = 0;
            for (String colKey : gTable.columnKeySet()) {
                Integer cellValue = (Integer)gTable.get((Object)rowKey, (Object)colKey);
                if (cellValue != null) {
                    int colIdx = t.columnIndex(colKey);
                    t.numberColumn(colIdx).append(cellValue.intValue());
                    rowSum += cellValue.intValue();
                    columnTotals[colIdx] = columnTotals[colIdx] + cellValue;
                    continue;
                }
                t.numberColumn(colKey).append(0.0f);
            }
            t.numberColumn(t.columnCount() - 1).append(rowSum);
        }
        if (t.column(0).type().equals((Object)ColumnType.STRING)) {
            t.column(0).appendCell("Total");
        } else {
            t.column(0).appendCell("");
        }
        int grandTotal = 0;
        for (int i = 1; i < t.columnCount() - 1; ++i) {
            t.numberColumn(i).append(columnTotals[i]);
            grandTotal += columnTotals[i];
        }
        t.numberColumn(t.columnCount() - 1).append(grandTotal);
        return t;
    }

    public static Table counts(Table table, String columnName) {
        return table.countBy(table.categoricalColumn(columnName));
    }

    public static Table percents(Table table, String column1) {
        Table countTable = CrossTab.counts(table, column1);
        Table percentTable = Table.create(countTable.name());
        percentTable.addColumns(countTable.column(0).copy());
        NumberColumn countsColumn = countTable.numberColumn("Count");
        DoubleColumn pctsColumn = DoubleColumn.create("Percents");
        double sum = countsColumn.sum();
        for (int i = 0; i < countsColumn.size(); ++i) {
            pctsColumn.append(countsColumn.get(i) / sum);
        }
        percentTable.addColumns(pctsColumn);
        return percentTable;
    }

    private static Table rowPercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Row Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(labels);
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            labels.append(xTabCounts.column(0).getString(i));
        }
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column column = xTabCounts.column(i);
            pctTable.addColumns(DoubleColumn.create(column.name()));
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            float rowTotal = (float)xTabCounts.numberColumn(xTabCounts.columnCount() - 1).get(i);
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (rowTotal == 0.0f) {
                    pctTable.numberColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.numberColumn(c).append((float)xTabCounts.numberColumn(c).get(i) / rowTotal);
            }
        }
        return pctTable;
    }

    private static Table tablePercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Table Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(labels);
        double grandTotal = xTabCounts.numberColumn(xTabCounts.columnCount() - 1).get(xTabCounts.rowCount() - 1);
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            labels.append(xTabCounts.column(0).getString(i));
        }
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column column = xTabCounts.column(i);
            pctTable.addColumns(DoubleColumn.create(column.name()));
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (grandTotal == 0.0) {
                    pctTable.numberColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.numberColumn(c).append((double)((float)xTabCounts.numberColumn(c).get(i)) / grandTotal);
            }
        }
        return pctTable;
    }

    private static Table columnPercents(Table xTabCounts) {
        int i;
        int i2;
        Table pctTable = Table.create("Crosstab Column Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(labels);
        for (i2 = 0; i2 < xTabCounts.rowCount(); ++i2) {
            labels.append(xTabCounts.column(0).getString(i2));
        }
        for (i2 = 1; i2 < xTabCounts.columnCount(); ++i2) {
            Column column = xTabCounts.column(i2);
            pctTable.addColumns(DoubleColumn.create(column.name()));
        }
        double[] columnTotals = new double[xTabCounts.columnCount() - 1];
        int totalRow = xTabCounts.rowCount() - 1;
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            columnTotals[i - 1] = xTabCounts.numberColumn(i).get(totalRow);
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (columnTotals[c - 1] == 0.0) {
                    pctTable.numberColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.numberColumn(c).append((double)((float)xTabCounts.numberColumn(c).get(i)) / columnTotals[c - 1]);
            }
        }
        return pctTable;
    }

    public static Table columnPercents(Table table, CategoricalColumn column1, CategoricalColumn column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.columnPercents(xTabs);
    }

    public static Table columnPercents(Table table, String column1, String column2) {
        return CrossTab.columnPercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }

    public static Table rowPercents(Table table, CategoricalColumn column1, CategoricalColumn column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.rowPercents(xTabs);
    }

    public static Table rowPercents(Table table, String column1, String column2) {
        return CrossTab.rowPercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }

    public static Table tablePercents(Table table, CategoricalColumn column1, CategoricalColumn column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.tablePercents(xTabs);
    }

    public static Table tablePercents(Table table, String column1, String column2) {
        return CrossTab.tablePercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }
}

