/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.index.CategoryIndex;
import tech.tablesaw.index.IntIndex;
import tech.tablesaw.index.LongIndex;
import tech.tablesaw.selection.Selection;

public class DataFrameJoiner {
    private final Table table;
    private final Column column;

    public DataFrameJoiner(Table table, String column) {
        this.table = table;
        this.column = table.column(column);
    }

    public Table inner(Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.inner(table2, this.column.name());
        }
        return joined;
    }

    public Table inner(Table table2, String col2Name) {
        return this.joinInternal(table2, col2Name, false);
    }

    private Table joinInternal(Table table2, String col2Name, boolean outer) {
        Table result = this.emptyTableFromColumns(this.table, table2, col2Name);
        if (this.column instanceof DateColumn) {
            IntIndex index = new IntIndex(table2.dateColumn(col2Name));
            DateColumn col1 = (DateColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                int value = col1.getIntInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissing(result, table1Rows, table2Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof DateTimeColumn) {
            LongIndex index = new LongIndex(table2.dateTimeColumn(col2Name));
            DateTimeColumn col1 = (DateTimeColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                long value = col1.getLongInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissing(result, table1Rows, table2Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof TimeColumn) {
            IntIndex index = new IntIndex(table2.timeColumn(col2Name));
            TimeColumn col1 = (TimeColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                int value = col1.getIntInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissing(result, table1Rows, table2Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof StringColumn) {
            CategoryIndex index = new CategoryIndex(table2.stringColumn(col2Name));
            StringColumn col1 = (StringColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                String value = col1.get(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissing(result, table1Rows, table2Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof DoubleColumn) {
            LongIndex index = new LongIndex(table2.numberColumn(col2Name));
            NumberColumn col1 = (NumberColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                long value = col1.getLong(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissing(result, table1Rows, table2Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else {
            throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + this.column.name() + " is of type " + (Object)((Object)this.column.type()));
        }
        return result;
    }

    public Table leftOuter(Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.leftOuter(table2, this.column.name());
        }
        return joined;
    }

    public Table leftOuter(Table table2, String col2Name) {
        return this.joinInternal(table2, col2Name, true);
    }

    public Table rightOuter(Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.rightOuter(table2, this.column.name());
        }
        return joined;
    }

    public Table rightOuter(Table table2, String col2Name) {
        Table leftOuter = table2.join(col2Name).leftOuter(this.table, this.column.name());
        Table result = Table.create(leftOuter.name());
        for (String name : this.table.columnNames()) {
            result.addColumns(leftOuter.column(name));
        }
        for (String name : table2.columnNames()) {
            if (result.columnNames().contains(name)) continue;
            result.addColumns(leftOuter.column(name));
        }
        return result;
    }

    private Table emptyTableFromColumns(Table table1, Table table2, String col2Name) {
        Column[] cols = (Column[])Streams.concat((Stream[])new Stream[]{table1.columns().stream(), table2.columns().stream().filter(c -> !c.name().equals(col2Name))}).map(col -> col.emptyCopy(col.size())).toArray(Column[]::new);
        return Table.create(table1.name(), cols);
    }

    private void crossProduct(Table destination, Table table1, Table table2) {
        for (int c = 0; c < table1.columnCount() + table2.columnCount(); ++c) {
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                for (int r2 = 0; r2 < table2.rowCount(); ++r2) {
                    if (c < table1.columnCount()) {
                        destination.column(c).appendCell(table1.getUnformatted(r1, c));
                        continue;
                    }
                    destination.column(c).appendCell(table2.getUnformatted(r2, c - table1.columnCount()));
                }
            }
        }
    }

    private void withMissing(Table destination, Table table1, Table table2) {
        for (int c = 0; c < table1.columnCount() + table2.columnCount(); ++c) {
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                if (c < table1.columnCount()) {
                    destination.column(c).appendCell(table1.getUnformatted(r1, c));
                    continue;
                }
                destination.column(c).appendMissing();
            }
        }
    }
}

