/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalTime;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.filtering.predicates.IntBiPredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface TimeFilters
extends Column {
    @Override
    public TimeColumn where(Selection var1);

    default public Selection eval(IntBiPredicate predicate, TimeColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getIntInternal(idx), otherColumn.getIntInternal(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(IntPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(IntBiPredicate predicate, int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(next, value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<LocalTime, LocalTime> predicate, LocalTime valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<LocalTime> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection isMidnight() {
        return this.eval(PackedLocalTime::isMidnight);
    }

    default public Selection isNoon() {
        return this.eval(PackedLocalTime::isNoon);
    }

    default public Selection isBefore(LocalTime time) {
        return this.isBefore(PackedLocalTime.pack(time));
    }

    default public Selection isBefore(int packedTime) {
        return this.eval(PackedLocalTime::isBefore, packedTime);
    }

    default public Selection isAfter(LocalTime time) {
        return this.isAfter(PackedLocalTime.pack(time));
    }

    default public Selection isAfter(int packedTime) {
        return this.eval(PackedLocalTime::isAfter, packedTime);
    }

    default public Selection isOnOrAfter(LocalTime time) {
        int packed = PackedLocalTime.pack(time);
        return this.isOnOrAfter(packed);
    }

    default public Selection isOnOrAfter(int packed) {
        return this.eval(PackedLocalTime::isOnOrAfter, packed);
    }

    default public Selection isOnOrBefore(LocalTime value) {
        int packed = PackedLocalTime.pack(value);
        return this.isOnOrBefore(packed);
    }

    default public Selection isOnOrBefore(int packed) {
        return this.eval(PackedLocalTime::isOnOrBefore, packed);
    }

    default public Selection isBeforeNoon() {
        return this.eval(PackedLocalTime::AM);
    }

    default public Selection isAfterNoon() {
        return this.eval(PackedLocalTime::PM);
    }

    default public Selection isNotEqualTo(LocalTime value) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int packedLocalTime = PackedLocalTime.pack(value);
        int i = 0;
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (packedLocalTime != next) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isEqualTo(LocalTime value) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int packedLocalTime = PackedLocalTime.pack(value);
        int i = 0;
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (packedLocalTime == next) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isEqualTo(TimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator intIterator = column.intIterator();
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (next == intIterator.nextInt()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isBefore(TimeColumn column) {
        return this.eval(DateAndTimePredicates.isLessThan, column);
    }

    default public Selection isAfter(TimeColumn column) {
        return this.eval(DateAndTimePredicates.isGreaterThan, column);
    }

    default public Selection isNotEqualTo(TimeColumn column) {
        return Selection.withRange(0, this.size()).andNot(this.isEqualTo(column));
    }

    public IntArrayList data();

    public LocalTime get(int var1);

    public int getIntInternal(int var1);
}

