/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;

public class RollingColumn {
    private final Column column;
    private final int window;

    public RollingColumn(Column column, int window) {
        this.column = column;
        this.window = window;
    }

    public NumberColumn mean() {
        return this.calc(AggregateFunctions.mean);
    }

    public NumberColumn median() {
        return this.calc(AggregateFunctions.median);
    }

    public NumberColumn geometricMean() {
        return this.calc(AggregateFunctions.geometricMean);
    }

    public NumberColumn sum() {
        return this.calc(AggregateFunctions.sum);
    }

    public NumberColumn pctChange() {
        return this.calc(AggregateFunctions.pctChange);
    }

    private String generateNewColumnName(AggregateFunction function) {
        boolean useSpaces = this.column.name().matches("\\s+");
        String separator = useSpaces ? " " : "";
        return this.column.name() + separator + (useSpaces ? function.functionName() : StringUtils.capitalize((String)function.functionName())) + separator + this.window;
    }

    public NumberColumn calc(AggregateFunction function) {
        DoubleColumn result = DoubleColumn.create(this.generateNewColumnName(function), this.column.size());
        for (int i = 0; i < this.window - 1; ++i) {
            result.append(NumberColumn.MISSING_VALUE);
        }
        for (int origColIndex = 0; origColIndex < this.column.size() - this.window + 1; ++origColIndex) {
            BitmapBackedSelection selection = new BitmapBackedSelection();
            selection.addRange(origColIndex, origColIndex + this.window);
            Column windowedColumn = this.column.subset(selection);
            if (!(windowedColumn instanceof DoubleColumn)) {
                throw new IllegalArgumentException("Cannot calculate " + function.functionName() + " on column of type " + (Object)((Object)windowedColumn.type()));
            }
            double calc = function.summarize((NumberColumn)windowedColumn);
            result.append(calc);
        }
        return result;
    }
}

