/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.StringColumn;

public class StringPredicates {
    public static final Predicate<String> isMissing = i -> i.equals(StringColumn.MISSING_VALUE);
    public static final Predicate<String> isNotMissing = i -> !i.equals(StringColumn.MISSING_VALUE);
    public static final Predicate<String> isUpperCase = StringUtils::isAllUpperCase;
    public static final Predicate<String> isLowerCase = StringUtils::isAllLowerCase;
    public static final BiPredicate<String, String> startsWith = String::startsWith;
    public static final BiPredicate<String, String> endsWith = String::endsWith;
    public static final BiPredicate<String, String> stringContains = String::contains;
    public static final BiPredicate<String, String> matchesRegex = (valueToTest, valueToCompareAgainst) -> {
        Pattern p = Pattern.compile(valueToCompareAgainst);
        Matcher m = p.matcher((CharSequence)valueToTest);
        return m.matches();
    };
    public static final BiPredicate<String, String> isEqualTo = String::equals;
    public static final BiPredicate<String, String> isNotEqualTo = (valueToTest, valueToCompareAgainst) -> !valueToTest.equals(valueToCompareAgainst);
    public static final BiPredicate<String, String> isEqualToIgnoringCase = String::equalsIgnoreCase;
    public static final Predicate<String> isAlpha = StringUtils::isAlpha;
    public static final Predicate<String> isAlphaNumeric = StringUtils::isAlphanumeric;
    public static final Predicate<String> isNumeric = StringUtils::isNumeric;
    public static final Predicate<String> isEmpty = StringUtils::isEmpty;
    public static final BiPredicate<String, Integer> isLongerThan = (valueToTest, valueToCompareAgainst) -> valueToTest.length() > valueToCompareAgainst;
    public static final BiPredicate<String, Integer> isShorterThan = (valueToTest, valueToCompareAgainst) -> valueToTest.length() < valueToCompareAgainst;
    public static final BiPredicate<String, Integer> hasEqualLengthTo = (valueToTest, valueToCompareAgainst) -> valueToTest.length() == valueToCompareAgainst.intValue();
}

